% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksic_sub.R
\name{ksic_sub}
\alias{ksic_sub}
\title{Extract Child KSIC Codes}
\usage{
ksic_sub(ksic, digit = 5, C = NULL, name = FALSE)
}
\arguments{
\item{ksic}{character.
A vector of KSIC codes to find child codes for.}

\item{digit}{integer.
The digit of the child classification to extract (1-5). Default is 5.}

\item{C}{integer.
The KSIC revision (9, 10, or 11). If NULL, \code{getOption("ksic.C", 11)} is used.}

\item{name}{logical.
If \code{TRUE}, returns names; if \code{FALSE}, returns codes. Default is \code{FALSE}.}
}
\value{
A list containing vectors of child codes or names for each input code. Returns a list element with \code{NA} if no child codes are found.
}
\description{
Extracts the child classification codes corresponding to the input KSIC codes. It can handle a vector containing codes with different numbers of digits.
}
\examples{
ksic_sub(c("26", "96", "52636"), digit = 4)

ksic_sub("58", digit = 5, name = TRUE)
}
