#' Make Human Resources Part A2
#'
#' @description  Part A2 --- COUNT of FT instructional staff by tenure status, medical school, and function
#'
#' @param df a dataframe
#'
#' @importFrom dplyr bind_rows filter select bind_rows group_by summarize ungroup arrange transmute
#' @importFrom rlang .data
#' @importFrom stringr str_to_upper
#'
#' @return A dataframe with the required IPEDS structure for this survey part
#' @export
#'

make_hr_part_A2 <- function(df) {

  colnames(df) <- stringr::str_to_upper(colnames(df))

  #set up the grid of options
  combos_A2 <- expand.grid(UNITID = get_ipeds_unitid(df),
                           TENURE = c(1:7),
                           ISMEDICAL = c(0:1),
                           INSTFUNCTION = c(1:3, 5),  #4 is generated by the system (subtotal of 1:3)
                           COUNT = 0)

  #produce the uploadable format
  partA2 <- df %>%
            dplyr::filter(.data$CURRENTEMPLOYEE == 1,
                          .data$INSTRUCTIONAL == 1, #instructional
                          .data$FTPT == "F") %>%
            dplyr::select("UNITID",
                          "TENURE",
                          "ISMEDICAL",
                          "INSTFUNCTION",
                          "COUNT") %>%
            #add extra combinations
            dplyr::bind_rows(combos_A2) %>%
            #aggregate the full data
            dplyr::group_by(.data$UNITID,
                            .data$TENURE,
                            .data$ISMEDICAL,
                            .data$INSTFUNCTION) %>%
            dplyr::summarize(COUNT = sum(.data$COUNT)) %>%
            dplyr::ungroup() %>%
            #sort for easy viewing
            dplyr::arrange(.data$TENURE,
                           .data$ISMEDICAL,
                           .data$INSTFUNCTION) %>%
            #format for upload
            dplyr::transmute(UNITID = .data$UNITID,
                             SURVSECT = "HR1",
                             PART = "A2",
                             TENURE = .data$TENURE,
                             ISMEDICAL = .data$ISMEDICAL,
                             INSTFUNCTION = .data$INSTFUNCTION,
                             COUNT = .data$COUNT
                             )

}
