% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HaploDip_GenoFreq.R
\name{compute_allele.freqs_W}
\alias{compute_allele.freqs_W}
\title{Compute per-window genotype frequencies, allele frequencies, and Fis}
\usage{
compute_allele.freqs_W(
  geno.data,
  pop.file,
  contigs,
  positions,
  window.size,
  dip_freq,
  verbose = TRUE
)
}
\arguments{
\item{geno.data}{A character matrix of genotype strings with dimensions
\code{n_sites x n_individuals}, as returned by [vcf2GT()].}

\item{pop.file}{A \code{data.frame} or \code{data.table} with at least two
columns: \code{ID} (individual identifiers matching the column names of
\code{geno.data}) and \code{Pop} (population labels).}

\item{contigs}{A character vector of length \code{n_sites} containing the
contig (chromosome) name for each variant site, as returned by [vcf2GT()].}

\item{positions}{A numeric vector of length \code{n_sites} containing the
physical position (bp) of each variant site, as returned by [vcf2GT()].}

\item{window.size}{A single positive integer giving the size of each
sliding window in base pairs.}

\item{dip_freq}{A single numeric value in the interval \code{(0, 1)}
giving the expected proportion of diploid individuals in the population.
The haploid proportion is set to \code{1 - dip_freq}. A value of
\code{0.5} corresponds to an equal sex ratio and is recommended for
standard haplo-diploid systems.}

\item{verbose}{Logical. If `TRUE` (default), print progress messages.}
}
\value{
A [data.table::data.table] with one row per population-contig-window
  combination and the following columns:
  \describe{
    \item{Pop}{Population label.}
    \item{Contig}{Contig (chromosome) name.}
    \item{Window_starts}{Genomic coordinate (bp) of the first position in
      the window.}
    \item{Window_ends}{Genomic coordinate (bp) of the last position in the
      window (\code{Window_starts + window.size - 1}).}
    \item{N_sites}{Total number of called genotype entries (diploid +
      haploid) within the window.}
    \item{N_F}{Number of diploid (female) genotype entries in the window.}
    \item{N_M}{Number of haploid (male) genotype entries in the window.}
    \item{N_AA}{Count of homozygous reference (\code{AA}) genotypes.}
    \item{N_Aa}{Count of heterozygous (\code{Aa}) genotypes.}
    \item{N_aa}{Count of homozygous alternative (\code{aa}) genotypes.}
    \item{N_A}{Count of haploid reference (\code{A}) genotypes.}
    \item{N_a}{Count of haploid alternative (\code{a}) genotypes.}
    \item{Freq.Ref}{Overall reference allele frequency in the window.}
    \item{Freq.Alt}{Overall alternative allele frequency in the window.}
    \item{Obs.Hom}{Observed proportion of homozygous diploid genotypes
      (\code{AA + aa}) relative to total entries.}
    \item{Obs.Het}{Observed proportion of heterozygous diploid genotypes
      (\code{Aa}) relative to total entries.}
    \item{Obs.M.Ref}{Observed proportion of haploid reference genotypes
      (\code{A}) relative to total entries.}
    \item{Exp.Hom}{Expected frequency of homozygous diploid genotypes
      under the haplo-diploid equilibrium model.}
    \item{Exp.Het}{Expected frequency of heterozygous diploid genotypes
      under the haplo-diploid equilibrium model.}
    \item{Exp.M.Ref}{Expected frequency of haploid reference genotypes
      under the haplo-diploid equilibrium model.}
    \item{Fis}{Inbreeding coefficient for the window, or \code{NA} when
      expected heterozygosity is zero.}
  }
}
\description{
Iterates over each population defined in \code{pop.file}, splits the
genotype data by contig, and slides a fixed-size window along each contig
to compute observed and expected genotype frequencies, allele frequencies,
and the inbreeding coefficient (Fis). Expected genotype frequencies are
derived from the haplo-diploid equilibrium model, where the proportion of
diploid and haploid individuals in the population is controlled by
\code{dip_freq}. Sex is inferred from ploidy: diploid genotypes
(\code{"0/0"}, \code{"0/1"}, \code{"1/1"}) are assumed to belong to females
and haploid genotypes (\code{"0"}, \code{"1"}) to males. Fis is computed as
\code{1 - (Obs.Het / Exp.Het)} and is set to \code{NA} when expected
heterozygosity is zero.
}
\details{
Haplo-diploid equilibrium model assumes a equal sex-ratio for three main reasons:
1: A sex-ratio different from 1:1 (e.g. 1:2) would break the assumptions of equal 
probability of contributing to next generation (selection and even drift)
2: Population sex-ratio is not sample sex-ratio. Sample sex-ratio might be different 
from population's sex-ratio due to time of the year when sampling took place, flower resources, etc.  
3: Sex-ratio might be different from didderent populations, across time and evolving. So its
estimation for one population might not hold for another or the same in the next breeding season

For the above mentioned reasons, we highly recomend that the sex-ratio 
is left has 0.5 (1:1) unless strong evidence existis of otherwise. 
A true sex-ratio different from 1:1 (assumed) should also be considered 
to explain the possible differences between observed and expected genotype
frequencies. In other words, sex-ratio different from 1:1 should 
change the genotype frequencies but not the allele frequencies.

Fis might not be reliable when the number of sampled diploids is to low
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")

result <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

geno <- compute_allele.freqs_W(geno.data   = gt,
                               pop.file    = pop.file,
                               contigs     = contigs,
                               positions   = pos,
                               window.size = 10000,
                               dip_freq    = 0.5)

}
\seealso{
[summarize_geno()] for computing weighted genome-wide summary
  statistics from the output.
}
