% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Haplo-Dip_Sex_Ref_Allele.R
\name{compute.Female.Male.allele.W}
\alias{compute.Female.Male.allele.W}
\title{Compute per-window reference allele frequencies by sex}
\usage{
compute.Female.Male.allele.W(
  geno.data,
  pop.file,
  contigs,
  positions,
  window.size,
  verbose = TRUE
)
}
\arguments{
\item{geno.data}{A character matrix of genotype strings with dimensions
\code{n_sites x n_individuals}, as returned by [vcf2GT()].}

\item{pop.file}{A \code{data.frame} or \code{data.table} with at least two
columns: \code{ID} (individual identifiers matching the column names of
\code{geno.data}) and \code{Pop} (population labels).}

\item{contigs}{A character vector of length \code{n_sites} containing the
contig (chromosome) name for each variant site, as returned by [vcf2GT()].}

\item{positions}{A numeric vector of length \code{n_sites} containing the
physical position (bp) of each variant site, as returned by [vcf2GT()].}

\item{window.size}{A single positive integer giving the size of each
sliding window in base pairs.}

\item{verbose}{Logical. If `TRUE` (default), print progress messages.}
}
\value{
A [data.table::data.table] with one row per population-contig-window
  combination and the following columns:
  \describe{
    \item{Pop}{Population label.}
    \item{Contig}{Contig (chromosome) name.}
    \item{Window_starts}{Genomic coordinate (bp) of the first position in
      the window.}
    \item{Window_ends}{Genomic coordinate (bp) of the last position in the
      window (\code{Window_starts + window.size - 1}).}
    \item{N_sites}{Total number of called genotype entries (diploid +
      haploid) within the window.}
    \item{Females.freq}{Reference allele frequency computed from diploid
      genotypes only: \code{(2*N_AA + N_Aa) / (2*N_dip)}.}
    \item{Males.freq}{Reference allele frequency computed from haploid
      genotypes only: \code{N_A / N_hap}.}
    \item{Total.freq}{Reference allele frequency computed from both sexes
      combined: \code{(2*N_AA + N_Aa + N_A) / (2*N_dip + N_hap)}.}
  }
}
\description{
Iterates over each population defined in \code{pop.file}, splits the
genotype data by contig, and slides a fixed-size window along each contig
to compute the reference allele frequency separately for diploid individuals
(females), haploid individuals (males), and both sexes combined. Sex is
inferred from ploidy: diploid genotypes (\code{"0/0"}, \code{"0/1"},
\code{"1/1"}) are assumed to belong to females and haploid genotypes
(\code{"0"}, \code{"1"}) to males.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")
result <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

sex_ref <- compute.Female.Male.allele.W(geno.data   = gt,
                                        pop.file    = pop.file,
                                        contigs     = contigs,
                                        positions   = pos,
                                        window.size = 10000)

}
\seealso{
[summarize_sex_ref()] for computing weighted genome-wide summary
  statistics from the output.
}
