% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_boxShapes.R
\name{boxShapes}
\alias{boxShapes}
\alias{diamond_rounded_box_fn}
\alias{diamond_sharp_box_fn}
\alias{boxDiamondGrob}
\alias{ellipse_box_fn}
\alias{boxEllipseGrob}
\alias{rack_box_fn}
\alias{boxRackGrob}
\alias{database_box_fn}
\alias{boxDatabaseGrob}
\alias{document_box_fn}
\alias{boxDocumentGrob}
\alias{documents_box_fn}
\alias{boxDocumentsGrob}
\alias{tape_box_fn}
\alias{boxTapeGrob}
\alias{server_box_fn}
\alias{boxServerGrob}
\title{Additional box shape helpers for `boxGrob`}
\usage{
diamond_rounded_box_fn(x = 0.5, y = 0.5, gp = gpar())

diamond_sharp_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxDiamondGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  rounded = TRUE,
  name = NULL
)

ellipse_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxEllipseGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)

rack_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxRackGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)

database_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxDatabaseGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)

document_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxDocumentGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)

documents_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxDocumentsGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)

tape_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxTapeGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)

server_box_fn(x = 0.5, y = 0.5, gp = gpar())

boxServerGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  name = NULL
)
}
\arguments{
\item{x}{Horizontal position inside the box viewport (0-1).}

\item{y}{Vertical position inside the box viewport (0-1).}

\item{gp}{A `gpar` object with styling information (fill/col/etc).}

\item{label}{The label to print - should be a number, text or expression.}

\item{width}{The box automatically adapts the size but you can force by specifying the width}

\item{height}{The box automatically adapts the size but you can force by specifying the height}

\item{just}{The justification for the text: left, center or right.}

\item{bjust}{The justification for the box: left, center, right, top or bottom.
See the \code{just} option for the \code{\link[grid]{viewport}}}

\item{txt_gp}{The \code{\link[grid]{gpar}} style to apply to the text. Set \code{boxGrobTxt} option
if you want to customize all the boxes at once.}

\item{box_gp}{The \code{\link[grid]{gpar}} style to apply to the box function of `box_fn` below.}

\item{rounded}{Logical; use rounded diamond (TRUE) or sharp diamond (FALSE).}

\item{name}{a character identifier for the \code{grob}. Used to find the \code{grob} on the display
list and/or as a child of another grob.}
}
\value{
A `grid` grob that draws the requested shape inside the box viewport.
}
\description{
These helper functions provide alternative box drawing functions that can be
passed to `boxGrob(..., box_fn = ...)` or used via convenience wrappers
(`boxDiamondGrob`, `boxEllipseGrob`, `boxRackGrob`). They are intentionally
lightweight and implemented using base `grid` primitives.

Two diamond variants are provided: a rounded diamond (default) implemented
with `xsplineGrob` for slightly softened corners, and a sharp diamond
implemented with `polygonGrob` for strict straight edges.

Approximates an ellipse using a polygon with many points; it respects the
box viewport so it scales correctly.

A rectangular box with a slightly darker top band to mimic a server / disk rack
look. Implemented by composing a rounded rectangle and an overlaying top
strip. The strip is drawn without border to avoid double outlines.

Draws a cylinder-like database symbol (ellipse top, rectangular body, base ellipse).

A document icon with a wavy bottom edge, useful to indicate printed output.

Draws a stack of document shapes by repeating the same shape with offsets.

Left/right curved edges to mimic tape-like icons.

A server-styled box with front-panel vent lines so it is visually distinct
from a rack (top strip) representation.
}
\details{
Shape functions are called with `x` and `y` in [0,1] inside the box viewport and with `box_gp` for styling; convenience wrappers match the `boxGrob` signature.
}
\examples{
# These functions are designed to be passed to `boxGrob(..., box_fn = ...)`.
grid::grid.newpage()
d <- boxGrob("Decision", box_fn = diamond_rounded_box_fn)
e <- boxGrob("Start", box_fn = ellipse_box_fn)
r <- boxGrob("Server", box_fn = rack_box_fn)
spreadHorizontal(list(d, e, r))
}
\seealso{
\code{\link{boxGrob}} for usage and the `box_fn` argument

Other flowchart components: 
\code{\link{align}},
\code{\link{boxGrob}()},
\code{\link{boxPropGrob}()},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{distance}()},
\code{\link{moveBox}()},
\code{\link{spread}}
}
\concept{flowchart components}
