% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_functions.R
\name{computeProximity}
\alias{computeProximity}
\title{Compute Proximity Matrix}
\usage{
computeProximity(data, proxType, side, isContainMissingValue)
}
\arguments{
\item{data}{A numeric matrix with n rows and p columns. Each row typically represents an observation.}

\item{proxType}{An integer specifying the type of proximity measure to use.}

\item{side}{An integer indicating the direction for computing proximity.}

\item{isContainMissingValue}{An integer indicating whether the input data contains missing values.}
}
\value{
A square matrix representing the proximity between rows or columns, depending on the selected side.
}
\description{
This function takes a numeric matrix and computes a square proximity matrix (similarity or distance) based on a specified method.
}
\details{
\strong{proxType}

Available proxType options include:

\itemize{
\item \code{0}: Euclidean
\item \code{1}: Pearson correlation
\item \code{2}: Kendall correlation
\item \code{3}: Spearman correlation
\item \code{4}: Adjusted tangent correlation (atancorr)
\item \code{5}: City-block (Manhattan) distance
\item \code{6}: Absolute Pearson correlation
\item \code{7}: Uncentered correlation
\item \code{8}: Absolute uncentered correlation
\item \code{20}: Hamman similarity (binary)
\item \code{21}: Jaccard index (binary)
\item \code{22}: Phi coefficient (binary)
\item \code{23}: Rao coefficient (binary)
\item \code{24}: Rogers-Tanimoto similarity (binary)
\item \code{25}: Simple matching coefficient (binary)
\item \code{26}: Sneath coefficient (binary)
\item \code{27}: Yule's Q (binary)
}

Ensure the data type matches the selected method. For example, binary methods should only be used on binary (0/1) data.

\strong{side}

Use \code{0} for row-wise proximity and \code{1} for column-wise proximity.

\strong{isContainMissingValue}

Set to \code{1} if the input data includes missing values; otherwise, use \code{0}.
}
