% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{param.krr}
\alias{param.krr}
\title{Param method for fitted Kernel Ridge Regression models}
\usage{
\method{param}{krr}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"krr"}, typically returned by
\code{\link{fastkrr}}.}

\item{...}{Additional arguments.}
}
\value{
Prints a human-readable panel and returns (invisibly) a named list
of hyperparameters.
}
\description{
Displays (and invisibly returns) the hyperparameters actually used by a
fitted object. For \code{krr} objects returned by \code{\link{fastkrr}},
this prints a concise hyperparameter panel (e.g., \code{rho}, \code{lambda},
\code{m}, \code{eps}, \code{n_threads}, \code{d}).
}
\details{
\strong{Pivoted approximation note}: When \code{opt = "pivoted"}, the
effective number of pivots \code{m} used during the approximation may be
smaller than the user-specified \code{m} because the algorithm can stop
early based on \code{eps}. If you want to confirm the initial \code{m}
that you set, please see the printed \emph{Call} (the original function
call shows your input arguments).
}
\examples{
# Data setting
set.seed(1)
lambda = 1e-4
d = 1
n = 50
rho = 1
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))

model = fastkrr(X, y, kernel="gaussian", opt="nystrom",
              rho=1, lambda=1e-4, m=200, n_threads=4, fastcv=FALSE)


class(model)
param(model)

}
\seealso{
\code{\link{fastkrr}}
}
