% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sim_i3plus3.R
\name{run_sim_i3plus3}
\alias{run_sim_i3plus3}
\title{Simulations for the i3+3 design.}
\usage{
run_sim_i3plus3(p.true,
                  mtd.true,
                  pT,
                  EI,
                  ncohort,
                  cohortsize = 3,
                  startdose = 1,
                  DU.pp = 0.95,
                  n.earlystop = 100,
                  extrasafe = FALSE,
                  ntrial = 1000,
                  seed = 6)
}
\arguments{
\item{p.true}{a vector or matrix containing the true toxicity probabilities of the investigational dose levels.}

\item{mtd.true}{a numeric value or a vector which specifies the true MTD.}

\item{pT}{a numeric value; the target DLT rate.}

\item{EI}{a vector which specifies the equivalence interval (EI).}

\item{ncohort}{a numeric value; the total number of cohorts.}

\item{cohortsize}{a numeric value; the cohort size.}

\item{startdose}{a numeric value; the starting dose level for the trial.}

\item{DU.pp}{a numeric value; the cutoff to remove an overly toxic dose for safety.
We recommend the default value of (\code{DU.pp=0.95}) for general use.}

\item{n.earlystop}{a numeric value; the early stopping parameter. If the number of participants
treated at the current dose reaches \code{n.earlystop},
stop the trial and select the MTD based on the observed data.
The default value \code{n.earlystop=100} essentially turns
off this type of early stopping.}

\item{extrasafe}{a logical value which specifies whether to implement a more strict safety rule (see more in the Details).}

\item{ntrial}{a numeric value; the total number of simulated trials.}

\item{seed}{a numeric value; the random seed for simulation.}
}
\value{
\code{run_sim_i3plus3()} returns:

(1) a dataframe (\code{$selection}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the selection percentage at each dose level,
       the percentage of early stopping without selecting the MTD,
       the percentage of overdosing selection (POS),
       the percentage of correct selection (PCS),
       the percentage of underdosing selection (PUS),
       the numbered index for the true MTD, respectively.

(2) a dataframe (\code{$allocation}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the number of participants treated at each dose level,
       the average number of participants treated,
       the percentage of overdosing assignment (POA),
       the percentage of correct assignment (PCA),
       the percentage of underdosing assignment (PUA),
       the numbered index for the true MTD, respectively.

(3) a list (\code{$setup}) containing user input parameters.
}
\description{
Conduct computer simulations for the i3+3 design.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The i3+3 design uses the following decision rules. If
          \eqn{\frac{y_d}{n_d}} is lower than the escalation boundary (i.e. below
          the EI), the decision is to escalate to the next higher dose; if
          \eqn{\frac{y_d}{n_d}} is between the escalation and de-escalation boundaries
          (i.e. inside the EI), the decision is to stay at the current dose; if
          \eqn{\frac{y_d}{n_d}} is higher than the de-escalation boundary (i.e. above
          the EI), there are two options: option one, if \eqn{\frac{y_d-1}{n_d}} is
          lower than the escalation boundary (i.e., below the EI), the decision is
          to stay at the current dose; option two, else if \eqn{\frac{y_d-1}{n_d}}
          is equal to or higher than the escalation boundary, the decision is to
          de-escalate to the next lower dose.

          Also, the i3+3 design includes a dose exclusion rule. Let \eqn{p_T} represents
          the target DLT rate. If \eqn{Pr(p_d > p_T | y_d , n_d ) > 0.95}, dose \eqn{d}
          and those higher than \eqn{d} are removed from the trial since they are deemed
          excessively toxic.

          The i3+3 design has two early stopping rules: (1) stop the trial if the lowest
         dose is eliminated due to toxicity, and no dose should be selected as the MTD; and
         (2) stop the trial and select the MTD if the number of participants treated at the current
         dose reaches \code{n.earlystop}.

         For some applications, investigators may prefer a more strict safety rule for MTD selection
         (This can be achieved by setting \code{extrasafe} == TRUE). If the isotonically-transformed
         posterior mean of the selected MTD is above the EI, select the next lower dose as the final MTD.
}
\examples{
run_sim_i3plus3(p.true = c(0.25, 0.41, 0.45, 0.49, 0.53),
           mtd.true = c(1,0,0,0,0),
           pT = 0.25,
           EI = c(0.2,0.3),
           ncohort = 9,
           cohortsize = 3,
           startdose = 1,
           DU.pp = 0.95,
           n.earlystop = 100,
           extrasafe = FALSE,
           ntrial = 1000,
           seed = 6)

}
\references{
Liu M., Wang, SJ. and Ji, Y. (2020). The i3+3 Design for Phase I Clinical Trials, \emph{Journal of
biopharmaceutical statistics}, 30(2):294–304.
}
