test_that("Variable and Type are correct", {
  DataProfile <- ProfileDataFrame(ChickWeight)
  expect_setequal(DataProfile$Variable, colnames(ChickWeight))
  n <- ncol(ChickWeight)
  TypeVec <- vector("character", n)
  for (i in 1:n){
    TypeVec[i] <- class(ChickWeight[, i])[1]
  }
  expect_equal(DataProfile$Type, TypeVec)
})
test_that("missing counts and fractions are zero",{
  DataProfile <- ProfileDataFrame(ChickWeight)
  expect_equal(DataProfile$nMiss, rep(0, ncol(ChickWeight)))
  expect_equal(DataProfile$fracMiss, rep(0, ncol(ChickWeight)))
})
test_that("levels and top feature characteristics are correct",{
  DataProfile <- ProfileDataFrame(ChickWeight)
  n <- ncol(ChickWeight)
  numLvl <- vector("numeric", n)
  topLvl <- vector("character", n)
  topChr <- vector("numeric", n)
  topFrq <- vector("numeric", n)
  topFrc <- vector("numeric", n)
  for (i in 1:n){
    tbl <- table(ChickWeight[, i])
    numLvl[i] <- length(tbl)
    index <- order(tbl, decreasing = TRUE)
    tbl <- tbl[index]
    top <- names(tbl)[1]
    topLvl[i] <- substr(top, 1, 20)
    topChr[i] <- nchar(top)
    freq <- as.numeric(tbl)[1]
    topFrq[i] <- freq
    topFrc[i] <- freq/sum(tbl)
  }
  expect_equal(DataProfile$nLevels, numLvl)
  expect_equal(DataProfile$topValue, topLvl)
  expect_equal(DataProfile$topChars, topChr)
  expect_equal(DataProfile$topFreq, topFrq)
  expect_equal(round(DataProfile$topFrac, digits = 3),
               round(topFrc, digits = 3))
})
test_that("Shannon homogeneity is correct", {
  DataProfile <- ProfileDataFrame(ChickWeight)
  homog <- as.numeric(unlist(apply(ChickWeight, MARGIN = 2,
                                   ShannonHomogeneity)))
  expect_equal(DataProfile$Homog, homog)
})
