% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox.evaluate.core.R
\name{wilcox.evaluate.core}
\alias{wilcox.evaluate.core}
\title{Wilcoxon Rank Sum Test}
\usage{
wilcox.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
\item{Trait}{The quantitative trait.} \item{Count}{The accession
  count (excluding missing data).} \item{EC_Med}{The median value of the
  trait in EC.} \item{CS_Med}{The median value of the trait in CS.}
  \item{Wilcox_pvalue}{The p value of the Wilcoxon test for equality of
  medians of EC and CS.} \item{Wilcox_significance}{The significance of the
  Wilcoxon test for equality of medians of EC and CS.}
}
\description{
Compare the medians of quantitative traits between entire collection (EC) and
core set (CS) by Wilcoxon rank sum test or Mann-Whitney-Wilcoxon test or
Mann-Whitney U test
\insertCite{wilcoxon_individual_1945,mann_test_1947}{EvaluateCore}.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

wilcox.evaluate.core(data = ec, names = "genotypes",
                     quantitative = quant, selected = core)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{wilcox.test}}
}
