% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_virus_parameters_SPT.R
\name{estimate_virus_parameters_SPT}
\alias{estimate_virus_parameters_SPT}
\title{Estimate SPT virus parameters using Bayesian inference with rstan}
\usage{
estimate_virus_parameters_SPT(
  data,
  D_LSin = 50,
  D_numPtsPdin = 1,
  mcmcOptions = c(500, 1000),
  numChainsIn = 4,
  mc.parallel = 0
)
}
\arguments{
\item{data}{A list containing the AP experiment data for Stan (required).}

\item{D_LSin}{Upper bound on insect vector lifespan in days, sets the vector survival discretisation (optional, default = 50).}

\item{D_numPtsPdin}{Number of points per day of insect vector lifespan, sets the vector survival discretisation (optional, default = 1).}

\item{mcmcOptions}{A numeric vector of length 2:
The first element specifies the number of warm-up iterations (optional, default = 500),
and the second element specifies the number of post-warm-up iterations (optional, default = 1000).}

\item{numChainsIn}{Numeric: number of Markov chains (optional, default = 4).}

\item{mc.parallel}{Binary: whether to use parallelisation for sampling (optional, default = 0, i.e. 1 core only).}
}
\value{
A list with seven elements:
\describe{
\item{array0}{First set of MCMC chains for estimated parameters (\code{c1[1]}, \code{c3[1]}, \code{c2[1]},\code{bD[1]} - and additionally \code{lp__} for reference only).}
\item{array1}{Second set of MCMC chains for virus parameters (\code{al[1]}, \code{be[1]}, \code{mu[1]}).}
\item{array2}{summary_stats (rhat, ess_bulk, ess_tail). \code{[1]}: R-hat statistic for convergence (should be close to 1); \code{[2-3]}: statistics for n-eff.}
\item{array3}{Validation list, AAP input test plant infection data, forward simulated 2.5th percentile, forward simulated 97.5th percentile.}
\item{array4}{Validation list, IAP input test plant infection data, forward simulated 2.5th percentile, forward simulated 97.5th percentile.}
\item{array5}{Mean and sd Bayesian R-squared values for model fit assessment, for AAP and IAP assays.}
\item{converge_results}{A list containing key sampler diagnostics: divergent transitions, maximum tree depth exceedances,
See also screen print for acceptability of energy Bayesian fraction of missing information (E-BFMI).).}
}
}
\description{
Runs MCMC sampling using a precompiled Stan model for SPT plant virus. Analyses SPT access period data directly estimating 4 parameters:
(\code{c1[1]}, \code{c3[1]}, \code{c2[1]},\code{bD[1]}, the first 3 are composite and the 4th corresponds to insect lab mortality rate).
The composite parameters can be unpacked into \code{al[1]}, \code{be[1]}, \code{mu[1]} - acquisition, inoculation, and insect recovery rates.
}
\details{
\strong{Interpreting model output - check stability first}

Warnings will be printed to the screen if there are issues with model fitting.
\strong{Do not suppress warnings} (e.g., via \code{suppressWarnings()}), as they contain essential information about
potential convergence problems.

Before interpreting any model results, always check the following \strong{core diagnostics}:
\enumerate{
\item \strong{R-hat} - Should be close to 1 for all parameters; larger values indicate non-convergence
(\href{https://mc-stan.org/learn-stan/diagnostics-warnings.html}{Stan R-hat documentation}).
\item \strong{Effective Sample Size (n_eff)} - Very low values suggest high autocorrelation or insufficient sampling
(\href{https://mc-stan.org/docs/2_19/reference-manual/effective-sample-size-section.html}{Stan ESS documentation}).
\item \strong{Divergent transitions} - Count should be 0; any non-zero count requires investigation
(\href{https://mc-stan.org/docs/2_19/reference-manual/divergent-transitions}{Stan divergences documentation}).
\item \strong{Posterior predictive fit (simulated_data)} - Compare model-simulated data with the observed data:
\itemize{
\item \code{array3}: AAP forward simulation 95\% credible intervals and original data
\item \code{array4}: IAP forward simulation 95\% credible intervals and original data
(\href{https://mc-stan.org/docs/stan-users-guide/posterior-predictive-checks.html}{Stan posterior predictive checks}).
}
}

\strong{Additional diagnostics for troubleshooting}

These are useful when core checks indicate problems, or for deeper exploration of model behaviour:
\itemize{
\item \strong{Bayesian R^2} (\code{r2_bayesA}, \code{r2_bayesI}) - Measures explanatory power;
low values suggest poor fit to the data (i.e., 2 values for AAP assay, IAP assay).
\item \strong{Max treedepth exceeded} - Number of times the sampler hit the maximum tree depth; should be 0
(\href{https://mc-stan.org/learn-stan/diagnostics-warnings.html}{Stan max treedepth documentation}).
\item \strong{EBFMI} (Energy Bayesian Fraction of Missing Information) - Low values indicate poor exploration
of the posterior.
}

See the package vignette for worked examples of checking and interpreting these diagnostics.

\strong{Preprint reference}

The models implemented in this function follow Donnelly et al. (2025, preprint), originally implemented in the EpiPv GitHub package.
}
\examples{
data("ap_data_sim_SPT", package = "EpiPvr")
# run low warm-up and iterations (mcmcOptions) for quick example only
EVSPT_pub=estimate_virus_parameters_SPT(
  data=ap_data_sim_SPT,D_LSin=5,D_numPtsPdin=1,
  mcmcOptions=c(25,50),numChainsIn=1,mc.parallel=0
)
}
\references{
Donnelly, R., Tankam, I. & Gilligan, C. (2025).
"Plant pathogen profiling with the EpiPv package."
EcoEvoRxiv, \doi{10.32942/X29K9P}.

When available, please cite the published version.
}
