% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{apply_kernel}
\alias{apply_kernel}
\title{Apply a kernel implied in an emc object}
\usage{
apply_kernel(
  kernel_pars,
  emc,
  subject = 1,
  input_pars = NULL,
  trend_n = 1,
  mode = "Rcpp"
)
}
\arguments{
\item{kernel_pars}{A named vector of kernel parameters on the natural scale.
Use \code{NULL} for kernels that do not require parameters.}

\item{emc}{An \code{emc}.}

\item{subject}{Subject index for which to apply the kernel. Defaults to \code{1}.}

\item{input_pars}{Optional parameter matrix containing externally supplied
parameter values (e.g., trend parameters). Only needed for custom kernels.}

\item{trend_n}{Integer specifying which trend to apply when multiple trends
exist in the model. Defaults to \code{1}. A warning is issued if the model
contains more than one trend.}

\item{mode}{Character string specifying which implementation to use:
\describe{
\item{\code{"R"}}{Use the pure R implementation.}
\item{\code{"Rcpp"}}{Use the Rcpp implementation (default).}
}}
}
\value{
Returns a kernel matrix produced by the corresponding implementation.
}
\description{
This function extracts the appropriate trend, and applies its implied kernel
using either the pure R implementation or the Rcpp version.
When \code{mode = "compare"}, the function checks whether the
two implementations produce identical output.
}
\details{
Applies the trend-specific kernel associated with an \code{emc} model to the
a subject's data and returns the resulting kernel matrix.
}
