% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eerr.R
\name{eerr}
\alias{eerr}
\title{Generate Data with Elliptically Distributed Covariates}
\usage{
eerr(n, p, dist_type)
}
\arguments{
\item{n}{The number of observations (rows) to generate.}

\item{p}{The number of predictors/dimensions (columns) for the covariate matrix X.}

\item{dist_type}{A character string specifying the type of elliptical distribution for X.
Must be one of "Elliptical-Normal", "Elliptical-t", or "Elliptical-cov".}
}
\value{
A list containing the following components:
\item{X}{An n x p matrix of covariates from the specified elliptical distribution.}
\item{Y}{A numeric vector of n responses.}
\item{e}{A numeric vector of n error terms from a standard normal distribution.}
}
\description{
This function generates a dataset for a linear model where the covariate matrix X follows an elliptical distribution.
}
\details{
The function generates a response vector Y based on the linear model Y = X %*% beta + e.
The covariate matrix X is generated from one of three types of elliptical distributions:
1.  `Elliptical-Normal`: Based on a multivariate normal distribution structure.
2.  `Elliptical-t`: Based on a multivariate t-distribution structure.
3.  `Elliptical-cov`: Based on a custom covariance matrix adjusted via its eigenvalues.
The error term 'e' is drawn from a standard normal distribution.
}
\examples{
# Generate 100 observations with 5 predictors from an Elliptical-Normal distribution
data_normal <- eerr(n = 100, p = 5, dist_type = "Elliptical-Normal")
str(data_normal)

# Generate 100 observations with 3 predictors from an Elliptical-cov distribution
data_cov <- eerr(n = 100, p = 3, dist_type = "Elliptical-cov")
pairs(data_cov$X) # Visualize the relationships between covariates

}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}

Guo, G., Sun, Y., Qian, G., & Wang, Q. (2022). LIC criterion for optimal subset selection in distributed interval estimation. \emph{Journal of Applied Statistics}, 50(9), 1900-1920. \doi{10.1080/02664763.2022.2053949}.

Chang, D., Guo, G. (2024). LIC: An R package for optimal subset selection for distributed data. \emph{SoftwareX}, 28, 101909.

Jing, G., & Guo, G. (2025). TLIC: An R package for the LIC for T distribution regression analysis. \emph{SoftwareX}, 30, 102132.

Chang, D., & Guo, G. Research on Distributed Redundant Data Estimation Based on LIC. \emph{IAENG International Journal of Applied Mathematics}, 55(1), 1-6 (2025).

Gao, H., & Guo, G. LIC for Distributed Skewed Regression. \emph{IAENG International Journal of Applied Mathematics}, 55(9), 2925-2930 (2025).

Zhang, C., & Guo, G. (2025). The optimal subset estimation of distributed redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 270-277.

Jing, G., & Guo, G. (2025). Student LIC for distributed estimation. \emph{IAENG International Journal of Applied Mathematics}, 55(3), 575-581.

Liu, Q., & Guo, G. (2025). Distributed estimation of redundant data. \emph{IAENG International Journal of Applied Mathematics}, 55(2), 332-337.
}
