% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotTreatment}
\alias{plotTreatment}
\title{Generate a custom ggplot2 from a summarised_result object generated with
summariseTreatment function.}
\usage{
plotTreatment(
  result,
  x = "variable_level",
  position = "stack",
  facet = cdm_name + cohort_name ~ window_name,
  colour = "variable_level",
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Variable to plot on x-axis}

\item{position}{Position of bars, can be either \code{dodge} or \code{stack}}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character, this
may be either the name of a built-in style (see \code{plotStyle()}), or a path to
a \code{.yml} file that defines a custom style. If NULL, the function will use the
explicit default style, unless a global style option is set (see
\code{visOmopResults::setGlobalPlotOptions()}) or a \verb{_brand.yml} file is present
(in that order). Refer to the \strong{visOmopResults} package vignette on styles
to learn more.}
}
\value{
A ggplot2 object.
}
\description{
Generate a custom ggplot2 from a summarised_result object generated with
summariseTreatment function.
}
\examples{
\dontrun{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
result <- cdm$cohort1 |>
  summariseTreatment(
    treatmentCohortName = "cohort2",
    window = list(c(0, 30), c(31, 365))
  )

plotTreatment(result)

plotTreatment(result, x = "cohort_name", facet = "window_name")
}

}
