##' A metabolite data set. The Arabidopsis metabolome of the aerial
##' regions of individual WT plants and the mto1 and tt4 mutants
##' were analyzed by GC-TOF/MS. 
##'
##' 50 samples (WT, n = 17; mto1, n = 13; and tt4, n = 20, biological
##' replicates).
##' 
##' A matrix containing  59 metabolites (rows) and 50 observations 
##' (columns).
##'
##' MetaboLights accession no.: MTBLS40
##' 
##' For comparisons with data from roots (Fukushima et al. 2011) we selected 
##' 59 commonly-detected metabolites in both datasets using 
##' MetMask http://metmask.sourceforge.net.
##' 
##' @name AraMetLeaves
##' @docType data
##' @aliases AraMetLeaves
##' @title A metabolite data set from Arabidopsis leaves by GC-TOF/MS
##' 
##' @keywords datasets
##' @references Miyako Kusano, Atsushi Fukushima et al. BMC Syst Biol 2007 1:53
##' @author Atsushi Fukushima
NULL


##' A metabolite data set. The Arabidopsis metabolome of the roots 
##' of individual WT plants and the mto1 and tt4 mutants were
##' analyzed by GC-TOF/MS. 
##'
##' 53 root samples (WT, n = 17; mto1 n = 16; and tt4, n = 20,
##' biological replicates).
##' 
##' A matrix containing  59 metabolites (rows) and 53 observations 
##' (columns).
##'
##' MetaboLights accession no.: MTBLS45
##' 
##' For comparisons with data from aerial parts (Kusano, Fukushima et al. 2007) 
##' we selected 59 commonly-detected metabolites in both datasets using 
##' MetMask http://metmask.sourceforge.net.
##' 
##' @name AraMetRoots
##' @docType data
##' @aliases AraMetRoots
##' @title A metabolite data set from Arabidopsis roots by GC-TOF/MS
##' 
##' @keywords datasets
##' @references Atsushi Fukushima et al. BMC Syst Biol 2011 5:1.
##' @author Atsushi Fukushima
NULL


##' Golub data set from CoXpress paper by Michael Watson. 
##'
##' This is a data.frame of AML/ALL leukaemia microarray 
##' study, originally from Golub et al Science 286:531 (1999). 
##' It comprises gene expression measurements from 38 tumor 
##' mRNA samples, including 27 cases of acute lymphoblastic 
##' leukemia (ALL) and 11 cases of acute myeloid leukemia 
##' (AML). The HU6800 Affymetrix array, which contains 6,800 
##' probe sets, was used. The dataset was filtered to remove 
##' genes with negative values in any sample, resulting in a 
##' final set of 2,568 genes.
##' 
##' @name golub.df
##' @docType data
##' @title A compiled expression data from Golub et al. (1999)
##' @keywords datasets
##' @references Michael Watson, BMC Bioinformatics 2006 7:509.
NULL

