% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{add_recruitment_time}
\alias{add_recruitment_time}
\title{Add recruitment time to a survival dataset}
\usage{
add_recruitment_time(
  data,
  rec_method,
  rec_period = NULL,
  rec_power = NULL,
  rec_rate = NULL,
  rec_duration = NULL
)
}
\arguments{
\item{data}{A dataframe containing survival data with columns: \code{time}, \code{status}, and \code{group}}

\item{rec_method}{Recruitment method: \code{"power"} for power model or \code{"PWC"} for piecewise constant model}

\item{rec_period}{Period length for the power model}

\item{rec_power}{Power parameter for the power model}

\item{rec_rate}{Comma-separated string of recruitment rates for the PWC model}

\item{rec_duration}{Comma-separated string of durations corresponding to each rate in the PWC model}
}
\value{
A dataframe with two additional columns:
\describe{
\item{rec_time}{Simulated recruitment time for each patient}
\item{pseudo_time}{Time from recruitment to event or censoring}
}
Class: \code{data.frame}
}
\description{
Simulates recruitment timing for each patient in a survival dataset using either a power model or a piecewise constant (PWC) model. The function appends recruitment times and pseudo survival times (time from recruitment to event or censoring).
}
\examples{
set.seed(123)
df <- data.frame(
  time = rexp(20, rate = 0.1),
  status = rbinom(20, 1, 0.8),
  group = rep(c("Control", "Treatment"), each = 10)
)
recruited <- add_recruitment_time(df, rec_method = "power", rec_period = 12, rec_power = 1)
head(recruited)

}
