% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict_scorch}
\alias{predict_scorch}
\title{Predict canopy scorch from `LAS` tree object following Cannon et al. 2025}
\usage{
predict_scorch(las, model = NULL, plot = FALSE)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing an individually
segmented tree collected from RIEGL vz400i Terrestrial Lidar Scanner}

\item{model}{`randomForests` model object containing histogram data generated
from `get_histogram` function. if `model` is `NULL`, then default model
from Cannon et al. 2025 is used. But custom model may be generated.}

\item{plot}{Boolean indicating whether reflectance histogram should be plotted}
}
\value{
predicted scorch as numeric vector
}
\description{
This function follows methods in Cannon et al. 2025 to predict crown scorch
of a `LAS` object representing an individual tree collected using a RIEGL vz400i
Terrestrial Lidar system. The function uses the 'relative reflectance' (in decibels)
and predicts crown scorch using `randomForests` following Cannon et al. 2025
}
\examples{
library(lidR)
library(CrownScorchTLS)

#download external data from github repo
url <- paste0(
  "https://raw.githubusercontent.com/jbcannon/CrownScorchTLS-data/main/data/manual-clip-trees/",
  "M-04-15549_post.laz")
las_file = tempfile(fileext = paste0(".", tools::file_ext(url)))
download.file(url, las_file, mode = "wb", quiet = TRUE)
las <- readLAS(las_file)

# or load your own data
#las <- readLAS('C:/path/to/your/file.laz')

predict_scorch(las) #using default model from Cannon et al. 2025
}
