% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tapered_estimator.R
\name{tapered_est}
\alias{tapered_est}
\title{Compute the Estimated Tapered Autocovariance Function over a Set of Lags.}
\usage{
tapered_est(
  X,
  rho,
  window_name,
  window_params = c(1),
  maxLag = length(X) - 1,
  type = "autocovariance",
  meanX = mean(X),
  custom_window = FALSE
)
}
\arguments{
\item{X}{A vector representing observed values of the time series.}

\item{rho}{A scale parameter in \eqn{(0, 1].}}

\item{window_name}{The name of the \link{window} function to be used. Possible values are:
tukey, triangular, power_sine, blackman_window, hann_poisson, welch. Alternatively, a custom window function can be provided, see the example in \link{taper_single}.}

\item{window_params}{A vector of parameters of the window function.}

\item{maxLag}{An optional parameter that determines the maximum lag to compute the estimated autocovariance function at. Defaults to \code{length(X) - 1}.}

\item{type}{Compute either the 'autocovariance' or 'autocorrelation'. Defaults to 'autocovariance'.}

\item{meanX}{The average value of \code{X}. Defaults to \code{mean(X)}.}

\item{custom_window}{If a custom window is to be used or not. Defaults to \code{FALSE}.}
}
\value{
A vector whose values are the estimated tapered autocovariances.
}
\description{
This function computes the tapered autocovariance over a set of lags.
For each lag, the tapered autocovariance is computed using the function \link{tapered_single}.
}
\details{
This function computes the estimated tapered autocovariance over a set of lags,
\deqn{\widehat{C}_{N}^{a} (h) = (H_{2, n}(0))^{-1} \sum_{j=1}^{N-h}  (X(j) - \bar{X} ) ( X(j + h) - \bar{X} ) a((j - 1/2) / N; \rho) a((j + h - 1/2) / N; \rho) ,}
where \eqn{a(\cdot)} is a window function, \eqn{\rho \in (0, 1]}  is a scale parameter.
This estimator takes into account the edge effect during estimation, assigning a lower weight to values closer to the boundaries and higher weights for observations closer to the middle.
This estimator is positive-definite and asymptotically unbiased.

Internally, this function calls \link{tapered_single} for each lag \eqn{h}.
}
\examples{
X <- c(1, 2, 3)
tapered_est(X, 0.5, "tukey", maxLag = 2)
}
\references{
Dahlhaus R. & Künsch, H. (1987). Edge Effects and Efficient Parameter Estimation for Stationary Random Fields. Biometrika 74(4), 877-882. 10.1093/biomet/74.4.877
}
