% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{max_distance}
\alias{max_distance}
\title{Maximum Vertical Distance Between Estimated Functions.}
\usage{
max_distance(est1, est2, lags = c(), plot = FALSE)
}
\arguments{
\item{est1}{A numeric vector representing the first estimated autocovariance function.}

\item{est2}{A numeric vector of the same length as \code{est1} representing the second estimated autocovariance function}

\item{lags}{An optional vector of lags starting from 0 up until some other lag. If empty, a vector of lags is created starting from 0 until \code{len(est1) - 1}, by 1.}

\item{plot}{A boolean as to whether a plot should be created. By default, no plot is created.}
}
\value{
A numeric value representing the maximum vertical distance between the two estimated functions.
}
\description{
This function computes the maximum vertical distance between functions.
}
\details{
This function computes the maximum vertical distance between functions:
\deqn{D(\hat{C}_{1}(h), \hat{C}_{2}(h)) = \displaystyle \max_{h} \left| \hat{C}_{1}(h) - \hat{C}_{2}(h) \right| ,
}
where \eqn{\hat{C}_{1}(\cdot)} and \eqn{\hat{C}_{2}(\cdot)} are estimated autocovariance functions.
It assumes that the estimated values are given for the same set of lags.
The vectors of the function values must be of the same length.
}
\examples{
x <- seq(0, 5, by=0.1)
estCov1 <- exp(-x^2)
estCov2 <- exp(-x^2.1)
max_distance(estCov1, estCov2, lags=x)
max_distance(estCov1, estCov2, lags=x, plot = TRUE)
}
