% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCodelists.R
\name{compareCodelists}
\alias{compareCodelists}
\title{Compare overlap between two sets of codes}
\usage{
compareCodelists(codelist1, codelist2)
}
\arguments{
\item{codelist1}{Output of getCandidateCodes or a codelist}

\item{codelist2}{Output of getCandidateCodes.}
}
\value{
Tibble with information on the overlap of codes in both codelists.
}
\description{
Compare overlap between two sets of codes
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create a CDM object
downloadMockDataset(datasetName = "GiBleed",
                    path = NULL,
                    overwrite = NULL)
cdm <- mockCdmFromDataset(datasetName = "GiBleed")

# Compare two candidate_codes object
codes1 <- getCandidateCodes(
  cdm = cdm,
  keywords = "Arthritis",
  domains = "Condition",
  includeDescendants = TRUE)

codes2 <- getCandidateCodes(
  cdm = cdm,
  keywords = c("osteo"),
  domains = "Condition",
  includeDescendants = TRUE)

compareCodelists(
  codelist1 = codes1,
  codelist2 = codes2)

# Compare two codelists
acetaminophen <- getDrugIngredientCodes(cdm,
                                        name = "acetaminophen",
                                        nameStyle = "{concept_name}",
                                        type = "codelist")

hydrocodone <- getDrugIngredientCodes(cdm,
                                      name = "hydrocodone",
                                      nameStyle = "{concept_name}",
                                      type = "codelist")
compareCodelists(
  codelist1 = acetaminophen,
  codelist2 = hydrocodone)
# Notice that concept_name = NA as `codelist` class does not store this information
# for each concept.

# Compare two codelists_with_details
acetaminophen <- getDrugIngredientCodes(cdm,
                                        name = "acetaminophen",
                                        nameStyle = "{concept_name}",
                                        type = "codelist_with_details")

hydrocodone <- getDrugIngredientCodes(cdm,
                                      name = "hydrocodone",
                                      nameStyle = "{concept_name}",
                                      type = "codelist_with_details")
compareCodelists(
  codelist1 = acetaminophen,
  codelist2 = hydrocodone)

}
}
