% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableRelationshipIds.R
\name{availableRelationshipIds}
\alias{availableRelationshipIds}
\title{Get available relationships between concepts}
\usage{
availableRelationshipIds(
  cdm,
  standardConcept1 = "Standard",
  standardConcept2 = "Standard",
  domains1 = "Condition",
  domains2 = "Condition"
)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept1}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{standardConcept2}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{domains1}{Character vector with one or more of the OMOP CDM domain. If NULL, all domains are considered.}

\item{domains2}{Character vector with one or more of the OMOP CDM domain. If NULL, all domains are considered.}
}
\value{
A character vector with unique concept relationship values.
}
\description{
Get available relationships between concepts
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all relationship ids in the CDM between `Condition` and `Standard` concepts.
availableRelationshipIds(cdm = cdm,
                         standardConcept1 = "Standard",
                         standardConcept2 = "Standard",
                         domains1 = "Condition",
                         domains2 = "Condition")

}
}
