% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asCodelistWithDetails.R
\name{asCodelistWithDetails}
\alias{asCodelistWithDetails}
\alias{asCodelistWithDetails.codelist_with_details}
\alias{asCodelistWithDetails.codelist}
\alias{asCodelistWithDetails.candidate_codes}
\title{Coerce to a codelist with details}
\usage{
asCodelistWithDetails(x, cdm, ...)

\method{asCodelistWithDetails}{codelist_with_details}(x, ...)

\method{asCodelistWithDetails}{codelist}(x, cdm, ...)

\method{asCodelistWithDetails}{candidate_codes}(x, cdm, ...)
}
\arguments{
\item{x}{Only codelist and candidate_codes are currently supported.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{...}{For extensibility}
}
\value{
codelist
}
\description{
Coerce to a codelist with details
}
\examples{
\donttest{
library(omock)
library(CDMConnector)

# Creating CDM object
path <- downloadMockDataset(datasetName = "GiBleed",
                            path = NULL,
                            overwrite = NULL)
cdm <- mockCdmFromDataset(datasetName = "GiBleed")

# Create codelist_with_details from a codelist
codelist <- getDrugIngredientCodes(cdm,
                                   name = "acetaminophen",
                                   nameStyle = "{concept_name}",
                                   type = "codelist")

asCodelistWithDetails(codelist, cdm)

# Create codelist from a candidate_codes
codelist <- getCandidateCodes(cdm,
                             keywords = "arthritis")

asCodelistWithDetails(codelist)
}
}
