% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advectionF.R
\name{advectionFuniform}
\alias{advectionFuniform}
\title{Uniform advection field}
\usage{
advectionFuniform(spacepoints, u, v)
}
\arguments{
\item{spacepoints}{vector of coordinates (2 x d), where d is the number of locations/grid points}

\item{u}{velocity component along the x axis}

\item{v}{velocity component along the y axis}
}
\description{
Provides an advection field with constant orthogonal (u and v) components at each grid point. This mimics rigid translation in a given direction according to the components u and v of the velocity vector.
}
\examples{

library(ggquiver)
library(ggplot2)
## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

af <- advectionFuniform(spacepoints = coord,
                       u = 2,
                       v = 6)

## visualize advection field
dta <- data.frame(lon = coord[ ,1], lat = coord[ ,2], u = af[ ,1], v = af[ ,2])
ggplot(dta, aes(x = lon, y = lat, u = u, v = v)) +
geom_quiver() +
theme_light()

}
\references{
Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
