% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLabel.R
\name{addLabel}
\alias{addLabel}
\title{Add levels and labels to categorical or occasion covariate}
\usage{
addLabel(.Object, covariate, levels, labels)
}
\arguments{
\item{.Object}{Model object}

\item{covariate}{Existing covariate name}

\item{levels}{Unique values of categorical or occasion covariate column specified as numeric vector}

\item{labels}{Unique values specifying corresponding label names for levels of categorical or occasion covariate
column in data specified as character vector.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Allows users to specify the name and the associated value for each category/occasion of a
categorical/occasion covariate in a textual model object. Only applicable to the case where
the corresponding input data column of a categorical/occasion covariate is of class character.
}
\examples{
\donttest{
model <- pkmodel(columnMap = FALSE,
                 isPopulation = FALSE,
                 workingDir = tempdir())

model <- suppressWarnings(addCovariate(model,
                      covariate = "Gender",
                      type = "Categorical",
                      effect = c("V"),
                      levels = c(0, 1)))
model@isTextual <- TRUE
model <- addLabel(model, "Gender", c(1, 2), c("male", "female"))
}

}
