% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXC.R
\name{MIXC}
\alias{MIXC}
\title{Internal function for the Mixed-Effects Model Calibration Curve (MIXC)}
\usage{
MIXC(
  data = NULL,
  p,
  y,
  cluster,
  grid,
  method = c("slope", "intercept"),
  plot = TRUE,
  cluster_curves = FALSE,
  nsims_pi = 10000,
  CI = TRUE,
  CI_method = c("naive", "delta"),
  cl.level = 0.95
)
}
\arguments{
\item{data}{optional data frame containing the variables \code{p}, \code{y},
and \code{cluster}. If supplied, variable names should be given without
quotation marks.}

\item{p}{predicted probabilities (numeric vector) or name of the column in
\code{data}.}

\item{y}{binary outcome variable or the name of the column in \code{data}.}

\item{cluster}{Cluster identifier (factor, character, or integer) or name of
the column in \code{data}.}

\item{grid}{the grid for the calibration curve evaluation}

\item{method}{character, type of mixed-effects model: \code{"intercept"} (random intercept)
or \code{"slope"} (random slope). Default is \code{"slope"}.}

\item{plot}{logical, indicating whether to generate a calibration plot. Default is \code{TRUE}.}

\item{cluster_curves}{logical, whether to include cluster-specific curves in the plot.
Default is \code{FALSE}.}

\item{nsims_pi}{integer, number of simulations for prediction intervals. Default is \code{10000}.}

\item{CI}{logical, whether to calculate confidence intervals. Default is \code{TRUE}.}

\item{CI_method}{character, method for computing the confidence intervals of the observed proportions.
If \code{"delta"}, the delta method is applied. Conversely, when \code{CI_method == "naive"}, no correction is applied.
Default is \code{"naive"}.}

\item{cl.level}{the confidence level for the calculation of the confidence interval. Default is \code{0.95}.}
}
\value{
A list containing:
\describe{
  \item{\code{model}}{The fitted mixed-effects model object}
  \item{\code{cluster_data}}{Data frame with calibration data for each cluster}
  \item{\code{plot_data}}{Data frame with calibration data for the average cluster}
  \item{\code{observed_data}}{Data frame with calibration data for individual observations}
  \item{\code{plot}}{A \code{ggplot2} object if \code{plot = TRUE}, otherwise \code{NULL}}
}
}
\description{
Estimates the calibration curve using a logistic generalized linear mixed model.
}
\details{
This function estimates the calibration curves using a logistic generalized linear mixed model.
}
