% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGC.R
\name{CGC}
\alias{CGC}
\title{Internal function for the Clustered Grouped Calibration Curve (CGC)}
\usage{
CGC(
  data = NULL,
  p,
  y,
  cluster,
  cl.level = 0.95,
  ntiles = 10,
  cluster_curves = FALSE,
  plot = TRUE,
  size = 1,
  linewidth = 0.4,
  univariate = FALSE,
  method = c("grouped", "interval")
)
}
\arguments{
\item{data}{optional data frame containing the variables \code{p}, \code{y},
and \code{cluster}. If supplied, variable names should be given without
quotation marks.}

\item{p}{predicted probabilities (numeric vector) or name of the column in
\code{data}.}

\item{y}{binary outcome variable or the name of the column in \code{data}.}

\item{cluster}{cluster identifier (factor, character, or integer) or name of
the column in \code{data}.}

\item{cl.level}{the confidence level for the calculation of the confidence interval. Default is \code{0.95}.}

\item{ntiles}{integer, number of groups (tiles) for calibration. Default is \code{10}.}

\item{cluster_curves}{logical, whether to include cluster-specific calibration
curves in the plot. Default is \code{FALSE}.}

\item{plot}{logical, whether to return a calibration plot. Default is \code{TRUE}.}

\item{size}{numeric, point size for plotted curves. Default is \code{1}.}

\item{linewidth}{numeric, line width for plotted curves. Default is \code{0.4}.}

\item{univariate}{logical, whether to use univariate meta-analysis. Default is \code{FALSE}.}

\item{method}{character, grouping method: \code{"grouped"} (equal-sized groups) or
\code{"interval"} (interval-based). Default is \code{"grouped"}.}
}
\value{
A list containing:
\describe{
  \item{\code{plot_data}}{Data frame of meta-analysis calibration estimates.}
  \item{\code{trad_grouped}}{Data frame with traditional grouped calibration results.}
  \item{\code{observed_data}}{Data frame with per-observation calibration data.}
  \item{\code{cluster_data}}{Data frame with cluster-specific calibration summaries.}
  \item{\code{plot}}{A \code{ggplot2} object if \code{plot = TRUE}, otherwise \code{NULL}.}
}
}
\description{
Estimates the calibration curves using the CGC approach. The function supports two grouping methods:
equal-sized groups (\code{"grouped"}) or interval-based groups (\code{"interval"}).
Optionally, a calibration plot can be produced with cluster-specific curves.
}
\details{
When \code{method = "grouped"}, the predictions are divided into equal-sized bins using quantiles.
Conversely, if \code{method ="interval"}, the predictions are divided into fixed-width bins across [0, 1].

The function performs a meta-analysis within each group. This can be either a univariate or bivariate analysis,
which is specified in the \code{univariate} argument. The univariate analysis is performed using the
\code{\link[meta]{metaprop}} function and the bivariate analysis employs the \code{\link[metafor]{rma.mv}} function.
Hereafter, the results are aggregated and plotted as calibration curves.
}
