% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{bertopic_visualize_hierarchical_documents}
\alias{bertopic_visualize_hierarchical_documents}
\title{Visualize hierarchical documents and topics}
\usage{
bertopic_visualize_hierarchical_documents(
  model,
  docs,
  hierarchical_topics,
  topics = NULL,
  embeddings = NULL,
  reduced_embeddings = NULL,
  sample = NULL,
  hide_annotations = FALSE,
  hide_document_hover = TRUE,
  nr_levels = 10L,
  level_scale = c("linear", "log"),
  custom_labels = FALSE,
  title = NULL,
  width = NULL,
  height = NULL,
  file = NULL
)
}
\arguments{
\item{model}{A "bertopic_r" model.}

\item{docs}{Character vector of documents used in \code{fit} / \code{fit_transform}.}

\item{hierarchical_topics}{A data frame or Python object as returned by
\code{BERTopic.hierarchical_topics(docs, ...)}.}

\item{topics}{Optional integer vector of topic IDs to visualize.}

\item{embeddings}{Optional numeric matrix of document embeddings.}

\item{reduced_embeddings}{Optional numeric matrix of 2D reduced embeddings.}

\item{sample}{Optional numeric (0–1) or integer controlling subsampling of
documents per topic (forwarded to Python).}

\item{hide_annotations}{Logical; if TRUE, hide cluster labels in the plot.}

\item{hide_document_hover}{Logical; if TRUE, hide document text on hover
to speed up rendering.}

\item{nr_levels}{Integer; number of hierarchy levels to display.}

\item{level_scale}{Character, either "linear" or "log", controlling how
hierarchy distances are scaled across levels.}

\item{custom_labels}{Logical or character scalar controlling label
behavior (forwarded to Python).}

\item{title}{Optional character plot title.}

\item{width, height}{Optional integer figure width/height in pixels.}

\item{file}{Optional HTML output path. If NULL, an \code{htmltools::HTML}
object is returned.}
}
\value{
If \code{file} is NULL, an \code{htmltools::HTML} object. Otherwise, the
normalized file path is returned invisibly.
}
\description{
Wrapper around Python \code{BERTopic.visualize_hierarchical_documents()}.
This function visualizes documents and their topics in 2D at different
levels of a hierarchical topic structure.
}
