% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NScheck.R
\name{NScheck}
\alias{NScheck}
\title{Verification of compliance with the no-subsidy constraints}
\usage{
NScheck(
  c,
  x,
  eta = rep(1, length(x)),
  group_contribution = TRUE,
  coalition = FALSE,
  tol = 1e-06
)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{x}{A numeric cost allocation vector.}

\item{eta}{A numeric vector representing the size of each group of cloned agents. All its elements must be positive integers. By default, all components of \code{eta} are set to 1.}

\item{group_contribution}{A logical value.
By default, if \code{group_contribution = TRUE}, \code{x} stores the aggregated contribution for each group of clones.
However, if \code{group_contribution = FALSE}, \code{x} represents the individual contribution of one of the agents in the group of clones.}

\item{coalition}{A logical value. By default, if \code{coalition = FALSE}, the function only returns whether the NS constraint is satisfied or not.
However, if \code{coalition = TRUE}, the function also returns the coalition of agents that breach the NS constraint, if it is violated.}

\item{tol}{Tolerance level for evaluating compliance with the NS constraint.}
}
\value{
If \code{coalition = TRUE}, a logical value (TRUE or FALSE) indicating compliance with the NS constraint.

Otherwise, if \code{coalition = FALSE}, a list containing the following items:
\tabular{lll}{
  \code{flag} \tab \tab  A logical value (TRUE or FALSE) indicating compliance with the NS constraint. \cr
  \code{eta} \tab \tab  If the NS constraint is violated, the coalition of agents that breach it will be returned. \cr
}
}
\description{
\code{NScheck} evaluates whether or not the no-subsidy constraint is satisfied and, if not,
it can also determine one of the coalitions of agents that violates it, as long as the user requests it.
}
\details{
For each \eqn{c\in C^N} let \eqn{H(c)=\{x\in\mathbb{R}:x(N)=c_n\}} be the hyperplane of \eqn{\mathbb{R}^N}
given by all the vectors whose coordinates add up to \eqn{c_n}. A cost allocation for \eqn{c\in C^N} is a vector
\eqn{x\in H(c)} such that \eqn{0\leq x\leq c}. The component \eqn{x_i} is the contribution requested from agent \eqn{i}.
Let \eqn{X(c)} be the set of cost allocations for \eqn{c\in C^N}. Given \eqn{x\in X(c)}, the difference \eqn{c_i-x_i} is the
benefit of agent \eqn{i} at \eqn{x}.

A basic requirement is that at an allocation \eqn{x\in X(c)} on group \eqn{N'\subset N}
of agents would subsidize the other agents by contributing more than what the group would have to pay on its own. The no-subsidy constraint
for the group \eqn{N'\subset N} is \eqn{x(N')\geq \text{max}\{c_j:j\in N'\}}. The set of cost allocations for \eqn{c\in C^N} that satisfy the no-subsidy
constraints, the no-subsidy set for short, is given by:
\deqn{
NS(c)=\{x\in X(c):x(N')\leq\text{max}\{c_j:j\in N'\}, \;\text{for all}\; N'\subset N\}}
\deqn{= \{x\in \mathbb{R}^N:x\geq 0, \ x(N)=c_n, \ x_1+\dots+x_i\leq c_i,\;\text{for all}\;i\in N\backslash \{n\}\}
}
Thus, the no-subsidy correspondence NS assigns to each \eqn{c\in C^N} the set \eqn{NS(c)}.

Nevertheless, when a problem has group of cloned agents, the structure of its no-subsidy set is simpler than
when all the cost parameters are different. Let \eqn{t\in N}, \eqn{\mathcal{A}_t^N} be the set of pairs \eqn{(\eta,c)\in \mathbb{N}^t\times\mathbb{R}^t} and \eqn{N_s^{\eta}=N_s^{\eta\ast c}=\{j\in N:(n\ast c)_j=c_s\}}.
Then the no subsidy set for \eqn{\eta\ast c \in C^N} is:
\deqn{
NS(\eta\ast c)=\{x\in\mathbb{R}:x\geq 0,\ x(N)=c_t,\ x(N_1^{\eta})+\dots+x(N^{\eta}_s)\leq c_s, \;\text{for all}\; s<t\}.
}
It is worth noting that all allocation rules proposed in this package satisfy this property.
}
\examples{
# Compliance with the NS constraint
c <- c(2, 5, 9)
x <- SECrule(c)
NScheck(c, x)
# Non-compliance with the NS constraint
c <- c(2, 3, 7, 10)
x <- c(1, 2, 5, 2)
NScheck(c, x, coalition = TRUE)

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{NSfaces}}, \code{\link{NSstructure}}, \code{\link{NSset}}, \code{\link{comparisonallocations}}
}
