% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurtosis.R
\name{kurtosis}
\alias{kurtosis}
\alias{kurtosis.default}
\alias{kurtosis.matrix}
\alias{kurtosis.data.frame}
\title{Kurtosis of the Sample}
\usage{
kurtosis(x, na.rm = FALSE, excess = FALSE)

\method{kurtosis}{default}(x, na.rm = FALSE, excess = FALSE)

\method{kurtosis}{matrix}(x, na.rm = FALSE, excess = FALSE)

\method{kurtosis}{data.frame}(x, na.rm = FALSE, excess = FALSE)
}
\arguments{
\item{x}{A vector of values, a \link{matrix} or a \link{data.frame}.}

\item{na.rm}{A \link{logical} to indicate whether \code{NA} values should be stripped before the computation proceeds.}

\item{excess}{A \link{logical} to indicate whether the \emph{excess kurtosis} should be returned, defined as the kurtosis minus 3.}
}
\description{
Kurtosis is a measure of the "tailedness" of the probability distribution of a real-valued random variable. A normal distribution has a kurtosis of 3 and a excess kurtosis of 0.
}
\examples{
kurtosis(rnorm(10000))
kurtosis(rnorm(10000), excess = TRUE)
}
\seealso{
\code{\link[=skewness]{skewness()}}
}
