% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabscreen_gpt.original.R
\name{tabscreen_gpt.original}
\alias{tabscreen_gpt.original}
\title{Title and abstract screening with GPT API models using function calls via the original function call arguments}
\usage{
tabscreen_gpt.original(
  data,
  prompt,
  studyid,
  title,
  abstract,
  ...,
  model = "gpt-4",
  role = "user",
  functions = incl_function_simple,
  function_call_name = list(name = "inclusion_decision_simple"),
  top_p = 1,
  time_info = TRUE,
  token_info = TRUE,
  api_key = get_api_key(),
  max_tries = 16,
  max_seconds = NULL,
  is_transient = gpt_is_transient,
  backoff = NULL,
  after = NULL,
  rpm = 10000,
  reps = 1,
  seed_par = NULL,
  progress = TRUE,
  messages = TRUE,
  incl_cutoff_upper = 0.5,
  incl_cutoff_lower = incl_cutoff_upper - 0.1,
  force = FALSE
)
}
\arguments{
\item{data}{Dataset containing the titles and abstracts.}

\item{prompt}{Prompt(s) to be added before the title and abstract.}

\item{studyid}{Unique Study ID. If missing, this is generated
automatically.}

\item{title}{Name of the variable containing the title information.}

\item{abstract}{Name of variable containing the abstract information.}

\item{...}{Further argument to pass to the request body.
See \url{https://platform.openai.com/docs/api-reference/chat/create}.}

\item{model}{Character string with the name of the completion model. Can take
multiple models, including gpt-4 models. Default = \code{"gpt-4"} (i.e., gpt-4-0613). This model has
been shown to outperform the gpt-3.5-turbo models in terms of its ability to detect
relevant studies (Vembye et al., Under preparation).
Find available model at
\url{https://platform.openai.com/docs/models/model-endpoint-compatibility}.}

\item{role}{Character string indicate the role of the user. Default is \code{"user"}.}

\item{functions}{Function to steer output. Default is \code{incl_function_simple}.
To get detailed responses use the hidden function call \code{incl_function} from the package. Also see 'Examples below.
Find further documentation for function calling at
\url{https://openai.com/blog/function-calling-and-other-api-updates}.}

\item{function_call_name}{Functions to call.
Default is \code{list(name = "inclusion_decision_simple")}. To get detailed responses
use \code{list(name = "inclusion_decision")}. Also see 'Examples below.}

\item{top_p}{'An alternative to sampling with temperature, called nucleus sampling,
where the model considers the results of the tokens with top_p probability mass.
So 0.1 means only the tokens comprising the top 10\% probability mass are considered.
We generally recommend altering this or temperature but not both.' (OPEN-AI). Default is 1.
Find documentation at
\url{https://platform.openai.com/docs/api-reference/chat/create#chat/create-top_p}.}

\item{time_info}{Logical indicating whether the run time of each
request/question should be included in the data. Default = \code{TRUE}.}

\item{token_info}{Logical indicating whether the number of prompt and completion tokens
per request should be included in the output data. Default = \code{TRUE}. When \code{TRUE},
the output object will include price information of the conducted screening.}

\item{api_key}{Numerical value with your personal API key. Find at
\url{https://platform.openai.com/account/api-keys}. Use
\code{\link[httr2:secrets]{httr2::secret_make_key()}}, \code{\link[httr2:secrets]{httr2::secret_encrypt()}}, and
\code{\link[httr2:secrets]{httr2::secret_decrypt()}} to scramble and decrypt the api key and
use \code{\link[=set_api_key]{set_api_key()}} to securely automate the use of the
api key by setting the api key as a locale environment variable.}

\item{max_tries, max_seconds}{'Cap the maximum number of attempts with
\code{max_tries} or the total elapsed time from the first request with
\code{max_seconds}. If neither option is supplied (the default), \code{\link[httr2:req_perform]{httr2::req_perform()}}
will not retry' (Wickham, 2023).}

\item{is_transient}{'A predicate function that takes a single argument
(the response) and returns \code{TRUE} or \code{FALSE} specifying whether or not
the response represents a transient error' (Wickham, 2023).}

\item{backoff}{'A function that takes a single argument (the number of failed
attempts so far) and returns the number of seconds to wait' (Wickham, 2023).}

\item{after}{'A function that takes a single argument (the response) and
returns either a number of seconds to wait or \code{NULL}, which indicates
that a precise wait time is not available that the \code{backoff} strategy
should be used instead' (Wickham, 2023).}

\item{rpm}{Numerical value indicating the number of requests per minute (rpm)
available for the specified api key. Find more information at
\url{https://platform.openai.com/docs/guides/rate-limits/what-are-the-rate-limits-for-our-api}.
Alternatively, use \code{\link[=rate_limits_per_minute]{rate_limits_per_minute()}}.}

\item{reps}{Numerical value indicating the number of times the same
question should be sent to OpenAI's GPT API models. This can be useful to test consistency
between answers. Default is \code{1} but when using 3.5 models, we recommend setting this
value to \code{10}.}

\item{seed_par}{Numerical value for a seed to ensure that proper,
parallel-safe random numbers are produced.}

\item{progress}{Logical indicating whether a progress line should be shown when running
the title and abstract screening in parallel. Default is \code{TRUE}.}

\item{messages}{Logical indicating whether to print messages embedded in the function.
Default is \code{TRUE}.}

\item{incl_cutoff_upper}{Numerical value indicating the probability threshold
for which a studies should be included. Default is 0.5, which indicates that
titles and abstracts that OpenAI's GPT API model has included more than 50 percent of the times
should be included.}

\item{incl_cutoff_lower}{Numerical value indicating the probability threshold
above which studies should be check by a human. Default is 0.4, which means
that if you ask OpenAI's GPT API model the same questions 10 times and it includes the
title and abstract 4 times, we suggest that the study should be check by a human.}

\item{force}{Logical argument indicating whether to force the function to use more than
10 iterations for gpt-3.5 models and more than 1 iteration for gpt-4 models.
This argument is developed to avoid the conduct of wrong and extreme sized screening.
Default is \code{FALSE}.}
}
\value{
An object of class \code{"chatgpt"}. The object is a list containing the following
components:
\item{answer_data_sum}{dataset with the summarized, probabilistic inclusion decision
for each title and abstract across multiple repeated questions.}
\item{answer_data_all}{dataset with all individual answers.}
\item{price}{numerical value indicating the total price (in USD) of the screening.}
\item{price_data}{dataset with prices across all gpt models used for screening.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\if{html}{\out{<br>}}
\if{html}{\out{<br>}}

This function has been deprecated (but can still be used) because
OpenAI has deprecated the function_call and and functions argument which is
used in this function. Instead use the \code{\link[=tabscreen_gpt.tools]{tabscreen_gpt.tools()}} that handles
the function calling via the tools and tool_choice arguments.\if{html}{\out{
<br>
}}


This function supports the conduct of title and abstract screening with GPT API models in R.
This function only works with GPT-4, more specifically gpt-4-0613. To draw on other models,
use \code{\link[=tabscreen_gpt.tools]{tabscreen_gpt.tools()}}.
The function allows to run title and abstract screening across multiple prompts and with
repeated questions to check for consistency across answers. This function draws
on the newly developed function calling to better steer the output of the responses.
This function was used in \href{https://osf.io/preprints/osf/yrhzm}{Vembye, Christensen, Mølgaard, and Schytt. (2025)}.
}
\note{
The \code{answer_data_sum} data contains the following mandatory variables:
\tabular{lll}{
\bold{studyid} \tab \code{integer} \tab indicating the study ID of the reference. \cr
\bold{title} \tab \code{character} \tab indicating the title of the reference. \cr
\bold{abstract} \tab \code{character}   \tab indicating the abstract of the reference. \cr
\bold{promptid} \tab \code{integer} \tab indicating the prompt ID. \cr
\bold{prompt} \tab \code{character} \tab indicating the prompt. \cr
\bold{model} \tab \code{character}   \tab indicating the specific gpt-model used. \cr
\bold{question} \tab \code{character} \tab indicating the final question sent to OpenAI's GPT API models. \cr
\bold{top_p} \tab \code{numeric}  \tab indicating the applied top_p. \cr
\bold{incl_p} \tab \code{numeric}  \tab indicating the probability of inclusion calculated across multiple repeated responses on the same title and abstract. \cr
\bold{final_decision_gpt} \tab \code{character} \tab indicating the final decision reached by gpt - either 'Include', 'Exclude', or 'Check'. \cr
\bold{final_decision_gpt_num}  \tab \code{integer}  \tab indicating the final numeric decision reached by gpt - either 1 or 0. \cr
\bold{longest_answer}  \tab \code{character} \tab indicating the longest gpt response obtained
across multiple repeated responses on the same title and abstract. Only included if the detailed function calling
function is used. See 'Examples' below for how to use this function. \cr
\bold{reps}  \tab \code{integer}  \tab indicating the number of times the same question has been sent to OpenAI's GPT API models. \cr
\bold{n_mis_answers} \tab \code{integer} \tab indicating the number of missing responses. \cr
}
\if{html}{\out{<br>}}
The \code{answer_data_all} data contains the following mandatory variables:
\tabular{lll}{
\bold{studyid} \tab \code{integer} \tab indicating the study ID of the reference. \cr
\bold{title} \tab \code{character} \tab indicating the title of the reference. \cr
\bold{abstract} \tab \code{character}   \tab indicating the abstract of the reference. \cr
\bold{promptid} \tab \code{integer} \tab indicating the prompt ID. \cr
\bold{prompt} \tab \code{character} \tab indicating the prompt. \cr
\bold{model} \tab \code{character}   \tab indicating the specific gpt-model used. \cr
\bold{iterations} \tab \code{numeric} \tab indicating the number of times the same question has been sent to OpenAI's GPT API models. \cr
\bold{question} \tab \code{character} \tab indicating the final question sent to OpenAI's GPT API models. \cr
\bold{top_p}  \tab \code{numeric} \tab indicating the applied top_p. \cr
\bold{decision_gpt}  \tab \code{character} \tab indicating the raw gpt decision - either \code{"1", "0", "1.1"} for inclusion, exclusion, or uncertainty, respectively. \cr
\bold{detailed_description}  \tab \code{character} \tab indicating detailed description of the given decision made by OpenAI's GPT API models.
Only included if the detailed function calling function is used. See 'Examples' below for how to use this function. \cr
\bold{decision_binary}  \tab \code{integer} \tab indicating the binary gpt decision,
that is 1 for inclusion and 0 for exclusion. 1.1 decision are coded equal to 1 in this case. \cr
\bold{prompt_tokens}  \tab \code{integer} \tab indicating the number of prompt tokens sent to the server for the given request. \cr
\bold{completion_tokens}  \tab \code{integer} \tab indicating the number of completion tokens sent to the server for the given request. \cr
\bold{run_time}  \tab \code{numeric} \tab indicating the time it took to obtain a response from the server for the given request. \cr
\bold{n} \tab \code{integer} \tab indicating request ID.  \cr
}
\if{html}{\out{<br>}}
If any requests failed to reach the server, the \code{chatgpt} object contains an
error data set (\code{error_data}) having the same variables as \code{answer_data_all}
but with failed request references only.\if{html}{\out{
<br>
}}


The \code{price_data} data contains the following variables:
\tabular{lll}{
\bold{model} \tab \code{character} \tab gpt model. \cr
\bold{input_price_dollar} \tab \code{integer} \tab price for all prompt/input tokens for the correspondent gpt-model. \cr
\bold{output_price_dollar}  \tab \code{integer} \tab price for all completion/output tokens for the correspondent gpt-model. \cr
\bold{price_total_dollar} \tab \code{integer} \tab total price for all tokens for the correspondent gpt-model. \cr
}

Find current token pricing at \url{https://openai.com/pricing}.
}
\examples{
\dontrun{

set_api_key()

prompt <- "Is this study about a Functional Family Therapy (FFT) intervention?"

tabscreen_gpt.original(
  data = filges2015_dat[1:2,],
  prompt = prompt,
  studyid = studyid,
  title = title,
  abstract = abstract,
  max_tries = 2
  )

 # Get detailed descriptions of the gpt decisions by using the
 # embedded function calling functions from the package. See example below.
 tabscreen_gpt.original(
   data = filges2015_dat[1:2,],
   prompt = prompt,
   studyid = studyid,
   title = title,
   abstract = abstract,
   functions = incl_function,
   function_call_name = list(name = "inclusion_decision"),
   max_tries = 2
 )
}
}
\references{
Vembye, M. H., Christensen, J., Mølgaard, A. B., & Schytt, F. L. W. (2025)
\emph{GPT API Models Can Function as Highly Reliable Second Screeners of Titles and Abstracts in Systematic Reviews:
A Proof of Concept and Common Guidelines} \url{https://osf.io/preprints/osf/yrhzm}

Wickham H (2023).
\emph{httr2: Perform HTTP Requests and Process the Responses}.
https://httr2.r-lib.org, https://github.com/r-lib/httr2.
}
