## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo = FALSE, message=FALSE---------------------------------------
library(rolap)

## -----------------------------------------------------------------------------
class(mrs_db)

## -----------------------------------------------------------------------------
mrs_db |>
  draw_tables()

## -----------------------------------------------------------------------------
mrs_db |> 
  get_fact_names()

## -----------------------------------------------------------------------------
mrs_cause <- mrs_db |> 
  get_star_database("mrs_cause")

class(mrs_cause)

mrs_cause |>
  draw_tables()

## -----------------------------------------------------------------------------
mrs_dm <- mrs_db |>
  as_dm_class()

class(mrs_dm)

mrs_dm

## -----------------------------------------------------------------------------
tl <- mrs_db |>
  as_tibble_list()

tl

## -----------------------------------------------------------------------------
tl <- mrs_db |>
  as_single_tibble_list()

tl

## -----------------------------------------------------------------------------
con <- DBI::dbConnect(RSQLite::SQLite())

mrs_db |>
  as_rdb(con)

DBI::dbListTables(con)

DBI::dbDisconnect(con)

## -----------------------------------------------------------------------------
f <- mrs_db |>
  as_xlsx_file(file = tempfile())

f

## -----------------------------------------------------------------------------
d <- mrs_db |>
  as_csv_files(dir = tempdir())

list.files(d, pattern = "*.csv")

## -----------------------------------------------------------------------------
ms <- mrs_db |>
  as_multistar()

class(ms)

