/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.PropEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropEqualX_YC;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualX_YC;
import org.chocosolver.solver.constraints.binary.PropLessOrEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropNotEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropNotEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropNotEqualX_YC;
import org.chocosolver.solver.constraints.unary.PropEqualXC;
import org.chocosolver.solver.constraints.unary.PropGreaterOrEqualXC;
import org.chocosolver.solver.constraints.unary.PropLessOrEqualXC;
import org.chocosolver.solver.constraints.unary.PropNotEqualXC;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

public class Arithmetic
extends Constraint {
    private final Operator op1;
    private final Operator op2;
    protected final int cste;
    private final IntVar[] vars;

    private static boolean isOperation(Operator operator) {
        return operator.equals((Object)Operator.PL) || operator.equals((Object)Operator.MN);
    }

    protected Arithmetic(String name, IntVar[] vars, Operator op1, Operator op2, int cste, Propagator prop) {
        super(name, prop);
        this.vars = vars;
        this.op1 = op1;
        this.op2 = op2;
        this.cste = cste;
    }

    Arithmetic(IntVar var, Operator op, int cste) {
        this("ARITHM", new IntVar[]{var}, op, Operator.NONE, cste, Arithmetic.createProp(var, op, cste));
    }

    private static Propagator createProp(IntVar var, Operator op, int cste) {
        switch (op) {
            case EQ: {
                return new PropEqualXC(var, cste);
            }
            case NQ: {
                return new PropNotEqualXC(var, cste);
            }
            case GE: {
                return new PropGreaterOrEqualXC(var, cste);
            }
            case GT: {
                return new PropGreaterOrEqualXC(var, cste + 1);
            }
            case LE: {
                return new PropLessOrEqualXC(var, cste);
            }
            case LT: {
                return new PropLessOrEqualXC(var, cste - 1);
            }
        }
        throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
    }

    Arithmetic(IntVar var1, Operator op, IntVar var2) {
        this("ARITHM", new IntVar[]{var1, var2}, op, Operator.PL, 0, Arithmetic.createProp(var1, op, var2));
    }

    private static Propagator createProp(IntVar var1, Operator op, IntVar var2) {
        switch (op) {
            case EQ: {
                return new PropEqualX_Y(var1, var2);
            }
            case NQ: {
                return new PropNotEqualX_Y(var1, var2);
            }
            case GE: {
                return new PropGreaterOrEqualX_Y(new IntVar[]{var1, var2});
            }
            case GT: {
                return new PropGreaterOrEqualX_YC(new IntVar[]{var1, var2}, 1);
            }
            case LE: {
                return new PropGreaterOrEqualX_Y(new IntVar[]{var2, var1});
            }
            case LT: {
                return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, 1);
            }
        }
        throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
    }

    Arithmetic(IntVar var1, Operator op1, IntVar var2, Operator op2, int cste) {
        this("ARITHM", new IntVar[]{var1, var2}, op1, op2, cste, Arithmetic.createProp(var1, op1, var2, op2, cste));
        if (Arithmetic.isOperation(op1) == Arithmetic.isOperation(op2)) {
            throw new SolverException("Incorrect formula; operators must be different!");
        }
    }

    private static Propagator createProp(IntVar var1, Operator op1, IntVar var2, Operator op2, int cste) {
        if (op1 == null) {
            throw new UnsupportedOperationException();
        }
        if (op2 == null) {
            throw new UnsupportedOperationException();
        }
        if (Arithmetic.isOperation(op1) == Arithmetic.isOperation(op2)) {
            throw new SolverException("Incorrect formula; operators must be different!");
        }
        IntVar[] vars = new IntVar[]{var1, var2};
        if (op1 == Operator.PL) {
            switch (op2) {
                case EQ: {
                    return new PropEqualXY_C(vars, cste);
                }
                case NQ: {
                    return new PropNotEqualXY_C(vars, cste);
                }
                case GE: {
                    return new PropGreaterOrEqualXY_C(vars, cste);
                }
                case GT: {
                    return new PropGreaterOrEqualXY_C(vars, cste + 1);
                }
                case LE: {
                    return new PropLessOrEqualXY_C(vars, cste);
                }
                case LT: {
                    return new PropLessOrEqualXY_C(vars, cste - 1);
                }
            }
            throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
        }
        Operator op = op2;
        if (op1 != Operator.MN) {
            cste *= op2 == Operator.PL ? 1 : -1;
            op = op1;
        }
        switch (op) {
            case EQ: {
                if (cste == 0) {
                    return new PropEqualX_Y(vars[0], vars[1]);
                }
                return new PropEqualX_YC(vars, cste);
            }
            case NQ: {
                if (cste == 0) {
                    return new PropNotEqualX_Y(vars[0], vars[1]);
                }
                return new PropNotEqualX_YC(vars, cste);
            }
            case GE: {
                if (cste == 0) {
                    return new PropGreaterOrEqualX_Y(vars);
                }
                return new PropGreaterOrEqualX_YC(vars, cste);
            }
            case GT: {
                if (cste == -1) {
                    return new PropGreaterOrEqualX_Y(vars);
                }
                return new PropGreaterOrEqualX_YC(vars, cste + 1);
            }
            case LE: {
                if (cste == 0) {
                    return new PropGreaterOrEqualX_Y(new IntVar[]{var2, var1});
                }
                return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, -cste);
            }
            case LT: {
                if (cste == 1) {
                    return new PropGreaterOrEqualX_Y(new IntVar[]{var2, var1});
                }
                return new PropGreaterOrEqualX_YC(new IntVar[]{var2, var1}, -cste + 1);
            }
        }
        throw new SolverException("Incorrect formula; operator should be one of those:{=, !=, >=, >, <=, <}");
    }

    @Override
    public Constraint makeOpposite() {
        Model model = this.vars[0].getModel();
        if (this.vars.length == 1) {
            return model.arithm(this.vars[0], Operator.getOpposite(this.op1).toString(), this.cste);
        }
        assert (this.vars.length == 2);
        if (this.op1 == Operator.PL || this.op1 == Operator.MN) {
            return model.arithm(this.vars[0], this.op1.toString(), this.vars[1], Operator.getOpposite(this.op2).toString(), this.cste);
        }
        return model.arithm(this.vars[0], Operator.getOpposite(this.op1).toString(), this.vars[1], this.op2.toString(), this.cste);
    }
}

