# Contributing to patterncausality

Thank you for your interest in contributing to patterncausality! 

## How to contribute

1. Fork the repository
2. Create a new branch for your feature
3. Make your changes
4. Add tests for new functionality
5. Run `devtools::check()`
6. Submit a pull request

## Code style

* Follow the tidyverse style guide
* Use roxygen2 for documentation
* Add examples to function documentation
* Keep functions focused and modular

## Testing

* Add tests for new functions
* Ensure all tests pass locally
* Maintain or improve code coverage

## Documentation

* Update vignettes if needed
* Keep README.md current
* Document all exported functions
