/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5FDfamily_H
#define H5FDfamily_H

#include "H5FDpublic.h" 

#define H5FD_FAMILY (H5OPEN H5FD_FAMILY_id_g)

#define H5FD_FAMILY_VALUE H5_VFD_FAMILY

#ifdef __cplusplus
extern "C" {
#endif

H5_DLLVAR hid_t H5FD_FAMILY_id_g;

H5_DLL herr_t H5Pset_fapl_family(hid_t fapl_id, hsize_t memb_size, hid_t memb_fapl_id);

H5_DLL herr_t H5Pget_fapl_family(hid_t fapl_id, hsize_t *memb_size , hid_t *memb_fapl_id );

#ifdef __cplusplus
}
#endif

#endif
