## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(boostmath)

## -----------------------------------------------------------------------------
#  The next representable value which is greater than x
print(float_next(1.0), digits = 20)
#  The next representable value which is smaller than x
print(float_prior(1.0), digits = 20)
# The number of distinct representations between a and b
print(float_distance(1.0, 2.0), digits = 20)
# A floating-point number r such that float_distance(val, r) == distance.
print(float_advance(1.0, 10), digits = 20)
# One unit in the last place of x
print(ulp(1.0), digits = 20)

## -----------------------------------------------------------------------------
# The relative distance/error E between two values as defined by: fabs((a - b) / min(a, b))
print(relative_difference(1.1, 1.1000009), digits = 20)
# A convenience function that returns relative_difference(a, b) / eps where eps is the machine epsilon for the result type
print(epsilon_difference(1.1, 1.1000009), digits = 20)

## -----------------------------------------------------------------------------
# Create a summation condition number object
scn <- summation_condition_number(kahan = TRUE)
# Add some values
scn$add(1.0)
scn$add(2.0)
scn$add(3.0)
# Compute sum, condition number, and L1 norm
print(scn$sum())
print(scn$condition_number())
print(scn$l1_norm())

# Compute evaluation condition number for a function
f <- function(x) { x^2 + 3*x + 2 }
print(evaluation_condition_number(f, 1.0))

