/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.xa.client.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAConnection
extends oracle.jdbc.xa.OracleXAConnection {
    protected boolean isXAResourceTransLoose = false;

    public OracleXAConnection() throws XAException {
    }

    public OracleXAConnection(Connection connection) throws XAException {
        super(connection);
    }

    @Override
    public synchronized XAResource getXAResource() throws SQLException {
        try {
            if (this.xaResource == null) {
                this.xaResource = new OracleXAResource(this.physicalConn, this);
                ((OracleXAResource)this.xaResource).isTransLoose = this.isXAResourceTransLoose;
                if (this.logicalHandle != null) {
                    ((oracle.jdbc.xa.OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                }
            }
        }
        catch (XAException xAException) {
            this.xaResource = null;
            if (xAException.getCause() instanceof SQLException) {
                throw (SQLException)xAException.getCause();
            }
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xAException);
        }
        return this.xaResource;
    }
}

