/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.IMemoryConsumer;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.temptable.ITemporaryTable;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public class ETTemporaryTableWrapper
extends ETRelationalExpr
implements IMemoryConsumer {
    private final ITemporaryTable m_temporaryTable;
    private boolean m_isOpen;
    private final List<IColumn> m_metadata;

    public ETTemporaryTableWrapper(boolean[] blArray, ITemporaryTable iTemporaryTable, List<IColumn> list) {
        super(blArray);
        this.m_temporaryTable = iTemporaryTable;
        this.m_isOpen = false;
        this.m_metadata = list;
    }

    @Override
    public void close(boolean bl) {
        this.m_temporaryTable.close(bl);
        this.m_isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void reset() throws ErrorException {
        this.m_temporaryTable.reset();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_metadata.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_metadata.size();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_temporaryTable.getRowCount();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_temporaryTable.open();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_temporaryTable.retrieveData(n, eTDataRequest);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean doMove() throws ErrorException {
        return this.m_temporaryTable.moveToNextRow();
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_temporaryTable.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        return this.m_temporaryTable.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_temporaryTable.getRequiredMemory();
    }
}

