# Kreutz-Clint file descriptions 

Descriptions of files found within invitroTKstats/inst/extdata/Kreutz-Clint and working/KreutzPFAS. 

The files tracked with the package are contained within this sub-directory, "inst/extdata/Kreutz-Clint", and are only a subset of all the raw data files found within the "working/KreutzPFAS" sub-directory (separate GitHub repository -- see below). We only track a subset of the raw data files due to size constraints. 

The unprocessed data files \insertCite{kreutz2023category}{invitroTKstats} are used within the "Data Guide Creation and Level-0 Data Compilation" vignette to demonstrate the initial steps of the pipelining process (raw data through L0 compilation); they are required to demonstrate how to extract relevant data from the **raw** data files to calculate point estimates of the intrinsic hepatic clearance (Cl~int~). 

### Unprocessed data 

The raw data files containing experimental mass spectrometry measurement data of intrinsic hepatic clearance (Cl~int~) for cryopreserved pooled human hepatocytes. Chemicals were per- and polyfluoroalkyl substance (PFAS) samples. The experiments were led by Dr.s Anna Kreutz and Barbara Wetmore.

**Files used for the Data-guide-and-L0_vignette and found here in the "inst/extdata":**

  * Hep_745_949_959_082421_final.xlsx
  * Hep_900_273_HC_082721_final.xlsx
  * Hep4_971_941_041122.xlsx
  
**Additional raw data files only found in the [invitrotkstats_dataproc GitHub repository](https://github.com/USEPA/invitrotkstats_dataproc) under the "working/KreutzPFAS" sub-directory:**

  * G6HC_474_3096_101621_final.xlsx
  * Hep_501_503_507_516_110421.xlsx
  * Hep_908_909_916_923_final.xlsx
  * Hep_913_AK_082421.xlsx
  * Hep_945_274_464_477_479_final.xlsx

*NOTE: All the raw/unprocessed data files listed above may be found in the "working/KreutzPFAS" sub-directory in the [invitrotkstats_dataproc repository](https://github.com/USEPA/invitrotkstats_dataproc).*

**CAUTION: We do not anticipate any changes in the unprocessed data files. If there are any new updates to these files, you must include a note log containing the date and explanation of changes at the end of this README.**