/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml.attribute;

import nu.xom.Attribute;
import org.xmlcml.stml.STMLAttribute;

public class IntSTAttribute
extends STMLAttribute {
    public static final String JAVA_TYPE = "int";
    public static final String JAVA_GET_METHOD = "getInt";
    public static final String JAVA_SHORT_CLASS = "IntSTAttribute";
    protected Integer i;

    public IntSTAttribute(String name) {
        super(name);
    }

    public IntSTAttribute(Attribute att) {
        this(att.getLocalName());
        String v = att.getValue();
        if (v != null && !v.trim().equals("")) {
            this.setSTMLValue(v);
        }
    }

    public IntSTAttribute(IntSTAttribute att) {
        super(att);
        if (att.i != null) {
            this.i = (int)att.i;
        }
    }

    @Override
    public Attribute copy() {
        return new IntSTAttribute(this);
    }

    public IntSTAttribute(Attribute att, String value) {
        super(att, value.trim().replace("\\s+", " "));
    }

    @Override
    public void setSTMLValue(String s) {
        if (s != null && !s.trim().equals("")) {
            int i;
            try {
                i = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("" + nfe);
            }
            this.setSTMLValue(i);
        }
    }

    public void setSTMLValue(int i) {
        this.checkValue(i);
        this.i = i;
        this.setValue("" + i);
    }

    public void checkValue(int i) {
        if (this.cmlType != null) {
            this.cmlType.checkValue(i);
        }
    }

    @Override
    public Object getSTMLValue() {
        return this.i;
    }

    public int getInt() {
        if (this.i == null) {
            throw new RuntimeException("integer attribute unset");
        }
        return this.i;
    }

    @Override
    public String getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    @Override
    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

