/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.sim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.GIS;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.Event;
import opennlp.model.MaxentModel;
import opennlp.tools.coref.resolver.ResolverUtils;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.NumberEnum;
import opennlp.tools.coref.sim.TestNumberModel;
import opennlp.tools.coref.sim.TrainSimilarityModel;
import opennlp.tools.util.CollectionEventStream;
import opennlp.tools.util.HashList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberModel
implements TestNumberModel,
TrainSimilarityModel {
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List<Event> events;
    private int singularIndex;
    private int pluralIndex;

    public static TestNumberModel testModel(String name) throws IOException {
        NumberModel nm = new NumberModel(name, false);
        return nm;
    }

    public static TrainSimilarityModel trainModel(String modelName) throws IOException {
        NumberModel gm = new NumberModel(modelName, true);
        return gm;
    }

    private NumberModel(String modelName, boolean train) throws IOException {
        this.modelName = modelName;
        if (train) {
            this.events = new ArrayList<Event>();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(modelName + this.modelExtension)).getModel();
            this.singularIndex = this.testModel.getIndex(NumberEnum.SINGULAR.toString());
            this.pluralIndex = this.testModel.getIndex(NumberEnum.PLURAL.toString());
        }
    }

    private List<String> getFeatures(Context np1) {
        ArrayList<String> features = new ArrayList<String>();
        features.add("default");
        Object[] npTokens = np1.getTokens();
        int tl = npTokens.length - 1;
        for (int ti = 0; ti < tl; ++ti) {
            features.add("mw=" + npTokens[ti].toString());
        }
        features.add("hw=" + np1.getHeadTokenText().toLowerCase());
        features.add("ht=" + np1.getHeadTokenTag());
        return features;
    }

    private void addEvent(String outcome, Context np1) {
        List<String> feats = this.getFeatures(np1);
        this.events.add(new Event(outcome, feats.toArray(new String[feats.size()])));
    }

    public NumberEnum getNumber(Context ec) {
        if (ResolverUtils.singularPronounPattern.matcher(ec.getHeadTokenText()).matches()) {
            return NumberEnum.SINGULAR;
        }
        if (ResolverUtils.pluralPronounPattern.matcher(ec.getHeadTokenText()).matches()) {
            return NumberEnum.PLURAL;
        }
        return NumberEnum.UNKNOWN;
    }

    private NumberEnum getNumber(List<Context> entity) {
        for (Context ec : entity) {
            NumberEnum ne = this.getNumber(ec);
            if (ne == NumberEnum.UNKNOWN) continue;
            return ne;
        }
        return NumberEnum.UNKNOWN;
    }

    @Override
    public void setExtents(Context[] extentContexts) {
        HashList entities = new HashList();
        ArrayList<Context> singletons = new ArrayList<Context>();
        for (Context ec : extentContexts) {
            if (ec.getId() != -1) {
                entities.put((Object)ec.getId(), ec);
                continue;
            }
            singletons.add(ec);
        }
        ArrayList<Context> singles = new ArrayList<Context>();
        ArrayList<Context> plurals = new ArrayList<Context>();
        for (Integer key : entities.keySet()) {
            List entityContexts = (List)entities.get(key);
            NumberEnum number = this.getNumber(entityContexts);
            if (number == NumberEnum.SINGULAR) {
                singles.addAll(entityContexts);
                continue;
            }
            if (number != NumberEnum.PLURAL) continue;
            plurals.addAll(entityContexts);
        }
        for (Context ec : singletons) {
            NumberEnum number = this.getNumber(ec);
            if (number == NumberEnum.SINGULAR) {
                singles.add(ec);
                continue;
            }
            if (number != NumberEnum.PLURAL) continue;
            plurals.add(ec);
        }
        for (Context ec : singles) {
            this.addEvent(NumberEnum.SINGULAR.toString(), ec);
        }
        for (Context ec : plurals) {
            this.addEvent(NumberEnum.PLURAL.toString(), ec);
        }
    }

    @Override
    public double[] numberDist(Context c) {
        List<String> feats = this.getFeatures(c);
        return this.testModel.eval(feats.toArray(new String[feats.size()]));
    }

    @Override
    public int getSingularIndex() {
        return this.singularIndex;
    }

    @Override
    public int getPluralIndex() {
        return this.pluralIndex;
    }

    @Override
    public void trainModel() throws IOException {
        new SuffixSensitiveGISModelWriter(GIS.trainModel(new CollectionEventStream(this.events), 100, 10), new File(this.modelName + this.modelExtension)).persist();
    }
}

