/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BinomialDist;
import umontreal.iro.lecuyer.randvar.BinomialGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BinomialConvolutionGen
extends BinomialGen {
    public BinomialConvolutionGen(RandomStream s, int n, double p) {
        super(s, null);
        this.setParams(n, p);
    }

    public BinomialConvolutionGen(RandomStream s, BinomialDist dist) {
        super(s, dist);
    }

    public int nextInt() {
        int x = 0;
        for (int i = 0; i < this.n; ++i) {
            double unif = this.stream.nextDouble();
            if (!(unif <= this.p)) continue;
            ++x;
        }
        return x;
    }

    public static int nextInt(RandomStream s, int n, double p) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be in [0,1]");
        }
        return BinomialConvolutionGen.convolution(s, n, p);
    }

    private static int convolution(RandomStream stream, int n, double p) {
        int x = 0;
        for (int i = 0; i < n; ++i) {
            double unif = stream.nextDouble();
            if (!(unif <= p)) continue;
            ++x;
        }
        return x;
    }
}

