.\"     $Id: l4_thread_switch.man,v 1.4 1998/01/22 05:45:28 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_THREAD_SWITCH 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_thread_switch \- release the processor non\-preemtively
.SH "Synopsis"
.br
\fB#include <l4/syscalls.h>\fP
.PP
\fBvoid l4_thread_switch(l4_threadid_t \fP\fIdest\fP \fB);\fP
.SH "Description"
The \fBl4_thread_switch()\fP system call frees the processor from the
invoking thread non\-preemptively so that another ready thread can be processed.
.SH "Arguments"
.IP "\fIdest\fP"
The identifier of the destination thread the processor
should switch to. 
.RS
.IP "\fBL4_NIL_ID\fP"
Processing switches to an undefined ready thread which
is selected by the scheduler.
.IP "<valid id>"
If the destination thread is ready, processing
switches to this thread. Otherwise another ready thread is selected by
the scheduler.
.RE
.SH "Return Values"
No return value is sent back.
.SH "See Also"
\fIl4_thread_ex_regs\fP, 
\fIl4_fpage_unmap\fP, 
\fIl4_myself\fP, 
\fIl4_id_nearest\fP,  
\fIl4_ipc\fP,
\fIl4_thread_schedule\fP, 
\fIl4_task_new\fP 
