.\"     $Id: l4_thread_schedule.man,v 1.5 1998/06/04 09:05:06 gernot Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_THREAD_SCHEDULE 2 "4.06.98" "UNSW" "System calls"
.SH NAME
l4_thread_schedule \-  Define priority, timeslice length and external preempter of
other threads.
.SH "Synopsis>"
.br
\fB#include <l4/syscalls.h>\fP
.PP
\fBstatic inline volatile cpu_time_t\fP 
.br
\fBl4_thread_schedule(l4_threadid_t \fP\fIdest\fP \fB,
l4_sched_param_t \fP \fIparam\fP \fB, \fBl4_threadid_t\fP
\fI*ext_preempter\fP \fB, l4_threadid_t\fP \fI*partner\fP \fB,
l4_sched_param_t \fP \fI*old_param\fP \fB,
\fBl4_threadid_t\fP \fI*old_ext_preempter\fP \fB);\fP
.SH "Description"
The \fBl4_thread_schedule()\fP system call can be used by schedulers to
define priority, timeslice length and external preempter of other
threads. Furthermore it delivers thread states.
.PP
The system call is only effective, if the current priority of the
specified destination is less than or equal to the current task's
maximum controlled priority (mcp).
.SH "Arguments"
.IP "\fIdest\fP"
The identifier of the destination thread. The 
destination thread must currently exist and run on a priority level
less than or equal to the current thread's mcp.
.IP "\fIparam\fP"
This word is split up into two sections. The upper 12 bits
contain the encoded length of the timeslice of the destination
thread. The timeslice quantum is encoded like a timeout. The following
12 bits should be zero. The remaining lowest 8 bits contain the new
priority for the destination thread.
.IP
If \fB0xFFFFFFFF\fP is given, the current priority and timeslice length of
the thread are not modified.
.IP "\fIext_preempter\fP"
The id of the external preempter for the
thread. If \fBL4_INVALID_ID\fP is given, the current external preempter of
the thread is not changed.
.IP "\fI*partner\fP"
Id of a partner of an active user\-invoked ipc
operation. This parameter is only valid, if the thread's user state is
sending, receiving, pending or waiting. \fBL4_INVALID_ID\fP is delivered if
there is no specific partner, i.e. if the thread is in an open receive
state.
.IP "\fI*old_param\fP"
This value contains the old priority, timeslice
length, state and priority of the destination thread. For an exact
description of the format refer to the L4 Reference Manual.
.IP
If \fB0xFFFFFFFF\fP is delivered, the addressed thread does
either not exist or has a priority which exceeds the current thread's mcp.
.IP "\fI*old_ext_preempter\fP"
Id of the old external preempter of the destination thread.
.SH "Return Values"
The returned 64 bit value contains the following information
(beginning with most significant bit):
.IP "\fImw\fP (8 bits), \fIew\fP (4 bits)"
Current user\-level wakeup of the
destination thread, encoded like a timeout. The value denotes the
still remaining timeout intervall. Valid only if the user state is
waiting or pending.
.IP "\fIep\fP (4 bits)"
Effective pagefault wakeup of the destination thread,
encoded like a 4\-bit pagefault timeout. The value denotes the still
remaining timeout interval. Valid only if the kernel state is pager.
.IP "\fIT\fP (48 bits)"
Cpu time in microseconds which has been consumed by
the destination thread.
.SH "See Also"
\fIl4_thread_ex_regs\fP, 
\fIl4_myself\fP, 
\fIl4_id_nearest\fP, 
\fIl4_ipc\fP,
\fIl4_thread_switch\fP, 
\fIl4_fpage_unmap\fP, 
\fIl4_task_new\fP 
