.\"     $Id: l4_thread_ex_regs.man,v 1.4 1998/01/22 05:45:27 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_THREAD_EX_REGS 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_thread_ex_regs \-  read and write register values of a thread, create a thread
.SH "Synopsis"
.br
\fB#include <l4/syscalls.h>\fP
.PP
\fBvoid l4_thread_ex_regs(l4_threadid_t \fP \fIdest\fP \fB,
dword_t \fP \fIeip\fP \fB, dword_t \fP \fIesp\fP \fB,
l4_threadid_t \fP \fI*excpt\fP \fB, l4_threadid_t\fP \fI*pager\fP
\fB, dword_t\fP \fI*old_eip\fP
\fB, dword_t \fP \fI*old_esp\fP \fB);\fP
.SH "Description"
The \fBl4_thread_ex_regs()\fP system call reads and writes user\-level 
register values of a thread in the actual task. Ongoing kernel
activities are not effected. An ipc operation is cancelled or aborted,
however. Setting stack and instruction pointer to different valid
values results in the creation of a new thread. 
.SH "Arguments"
.IP "\fIdest\fP"
The identifier of the destination thread.
.IP "\fIeip\fP"
The new instruction pointer of the thread. It must
point into the user\-accessible part of the address space. The existing
instruction pointer is not modified if \fB0xFFFFFFFFFFFFFFFF\fP is given. 
.IP "\fIesp\fP"
The new stack pointer for the thread. It must point into the
user\-accessible part of the address space. The existing stack
pointer is not modified if \fB0xFFFFFFFFFFFFFFFF\fP is given. 
.IP "\fI*excpt\fP"
Defines the exception handler thread id used by the thread. The
actual exception handler id is not modified if \fBL4_INVALID_ID\fP is given. 
.IP "\fI*pager\fP"
Defines the pager used by the thread. the actual pager id
is not modified if \fBL4_INVALID_ID\fP is given. 
.IP "\fI*old_eip\fP"
Old instruction pointer of the thread.
.IP "\fI*old_esp\fP"
Old stack pointer of the thread.
.SH "Return Values"
The thread id of the current thread is returned.
.SH "See Also"
\fIl4_fpage_unmap\fP, 
\fIl4_myself\fP, 
\fIl4_id_nearest\fP, 
\fIl4_ipc\fP,
\fIl4_thread_switch\fP, 
\fIl4_thread_schedule\fP, 
\fIl4_task_new\fP 
