.\"     $Id: l4_id_nearest.man,v 1.3 1998/01/22 05:45:13 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_ID_NEAREST 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_id_nearest \-  deliver the thread id of the nearest partner of the invoker
.SH "Synopsis"
.br
\fB#include <syscalls.h>\fP
.PP
\fBint l4_id_nearest(l4_threadid_t \fP\fIdest\fP , 
\fBl4_threadid_t \fP\fI*next_chief\fP\fB);\fP
.SH "Description"
The \fBl4_id_nearest()\fP system call delivers the id of the nearest partner
which would be engaged when sending a message to the specified destination.
.SH "Arguments"
.IP "\fIdest\fP"
Thread id of the destination.
.IP "\fI*next_chief\fP"
Pointer to thread id of the nearest partner,
depending on return value.
.SH "Return Values"
The following values determine the contents of the thread id,
next_chief is pointing to:
.IP "\fBL4_NC_SAME_CLAN\fP"
The destination resides in the same clan, its id is returned. 
.IP "\fBL4_NC_INNER_CLAN\fP"
The destination resides in an inner clan, whose chief is in the same
clan as the caller. The call returns the id of this chief.
.IP "\fBL4_NC_OUTER_CLAN\fP"
The destination is outside of the invoker's clan. It's own chief's id
is returned.
.SH "See Also"
\fIl4_thread_ex_regs\fP, 
\fIl4_fpage_unmap\fP, 
\fIl4_ipc\fP,
\fIl4_myself\fP, 
\fIl4_thread_switch\fP, 
\fIl4_thread_schedule\fP, 
\fIl4_task_new\fP 
