.\"     $Id: l4_fpage_unmap.man,v 1.4 1998/01/22 05:45:12 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_FPAGE_UNMAP 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_fpage_unmap \-  unmap an L4 flex page
.SH "Synopsis"
.br
\fB#include <l4/syscalls.h>\fP
.PP
\fBvoid l4_fpage_unmap(l4_fpage_t \fP\fIfpage\fP,
\fBdword_t \fP\fImap_mask\fP\fB);\fP
.SH "Description"
The \fBl4_fpage_unmap()\fP system call unmaps the specified flex page
in all address spaces into which the invoker mapped it directly or
indirectly.
.SH "Arguments"
.IP "\fIfpage\fP"
Fpage to be unmapped.
.IP "\fImap_mask\fP"
The following values are possible and can be combined partially:
.RS
.IP "\fBL4_FP_REMAP_PAGE\fP"
The flex page is set to read\-only. 
.IP "\fBL4_FP_FLUSH_PAGE\fP"
The flex page is completely unmapped.
.IP "\fBL4_FP_OTHER_SPACES\fP"
The flex page is unmapped in all address spaces into which it has been
mapped. The original flex page remains mapped.
.IP "\fBL4_FP_ALL_SPACES\fP"
The flex page is unmapped everywhere, including the original page.
.RE
.SH "Return Values"
No return value is sent back.
.SH "See Also"
\fIl4_thread_ex_regs\fP, 
\fIl4_myself\fP, 
\fIl4_id_nearest\fP, 
\fIl4_ipc\fP,
\fIl4_thread_switch\fP, 
\fIl4_thread_schedule\fP, 
\fIl4_task_new\fP 
