#include "fft.h"

static unsigned char tbl[256];

/* Initialize table of bit switched values for 8 bit numbers */
init_bitsw()
{
static int init = 0;
register int k;
if (init) return;
init = 1;
for (k=0; k < 256; k++) {
	tbl[k] = (unsigned char) slow_bitsw(k,8);
	}
}

/* "Fast" bitswitch for up to a short word (16 bits) */
/* Costs about 14 cycles per call		     */
int 
bitswitch(k,n)
register int n;
register int k;
{

/* Calculate bit switched value of k, by doing it */
/* 8 bits at a time:				  */
return( ((tbl[k & 0xff] << 8) | (tbl[k >> 8])) >> (16-n));
}

/* "Slow" bit switch - 30-40 cycles per call */
/* Only good up to 8 bits - used to initialize tbl[] */
int slow_bitsw(k,n)
int n;
register int k;
{
register int temp;

temp = k & 1; /* #1 */

k >>= 1;
temp = (temp << 1) + (k&1); /* #2 */
k >>= 1;
temp = (temp << 1) + (k&1); /* #3 */
k >>= 1;
temp = (temp << 1) + (k&1); /* #4 */
k >>= 1;
temp = (temp << 1) + (k&1); /* #5 */
k >>= 1;
temp = (temp << 1) + (k&1); /* #6 */
k >>= 1;
temp = (temp << 1) + (k&1); /* #7 */
k >>= 1;
temp = (temp << 1) + (k&1); /* #8 */
 
temp >>= (8-n);
return(temp);
}
