
#@# timeout: 8
#@# interval: 60

use Net::FTP;
use Math::TrulyRandom;
use strict;

my $arg = shift;

my ($addr, $user, $password);

if (ref($arg)) {
    $addr = $arg->{'addr'};
    $user = $arg->{'user'};
    $password = $arg->{'password'};
} else {
    $addr = $arg;
    $user = shift;
    $password = shift;
}

my $cookieFile = "upload-cookie.txt";

srand(truly_random_value());
my $random = rand 10000;

open(COOKIE, ">$cookieFile")
    or die "ftp-upload-page: can't create file $cookieFile: $!\n";
print COOKIE "$random $addr\n";
close(COOKIE);

my $ftp = new Net::FTP($addr, Debug => 1);

die "ftp-upload-page: can't connect to ftp server\n"
    if (not defined $ftp);

$ftp->login($user, $password)
    or die "ftp-upload-page: can't log in: ". $ftp->message;
$ftp->cwd("public_html")
    or die "ftp-upload-page: can't cwd to public_html: ". $ftp->message;
$ftp->put($cookieFile)
    or die "ftp-upload-page: can't put file $cookieFile: ". $ftp->message;

unlink($cookieFile);

open(FETCH, "fetch -q -o - http://$addr/~$user/$cookieFile|")
    or die "ftp-upload-page: can't popen fetch: $!\n";
my $reply = scalar <FETCH>;
close(FETCH)
    or die "ftp-upload-page: fetch failed: $!\n";

if ($reply =~ m/^$random ([\d.]+)\n/) {
    print $1, " 100\n";
    print STDERR "ftp-upload-page: cookie received okay - ip number is $1\n";
} else {
    print STDERR "ftp-upload-page: bad page received: $reply\n";
}

$ftp->delete($cookieFile)
    or warn "ftp-upload-page: could not delete cookie: ". $ftp->message;
$ftp->quit();
