/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.console;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.console.ConsoleMessage;
import org.netbeans.modules.web.webkit.debugging.api.console.PropertyMessage;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;

class RemoteObjectMessage
extends ConsoleMessage {
    private final RemoteObject ro;
    private final WebKitDebugging webKit;

    RemoteObjectMessage(WebKitDebugging webKit, RemoteObject ro) {
        super(ro.getOwningProperty());
        this.webKit = webKit;
        this.ro = ro;
    }

    @Override
    public String getType() {
        return this.ro.getType().getName();
    }

    @Override
    public String getText() {
        if (this.ro.getType() == RemoteObject.Type.OBJECT) {
            String className = this.ro.getClassName();
            if (className != null && className.startsWith("HTML") && className.endsWith("Element")) {
                List<PropertyDescriptor> properties = this.webKit.getRuntime().getRemoteObjectProperties(this.ro, true);
                for (PropertyDescriptor pd : properties) {
                    if (!"outerHTML".equals(pd.getName())) continue;
                    return pd.getValue().getValueAsString();
                }
            }
            return this.ro.getDescription();
        }
        return this.ro.getValueAsString();
    }

    @Override
    public List<ConsoleMessage> getSubMessages() {
        if (this.ro.getType() == RemoteObject.Type.OBJECT) {
            List<PropertyDescriptor> properties = this.ro.getProperties();
            ArrayList<ConsoleMessage> propMessages = new ArrayList<ConsoleMessage>(properties.size());
            for (PropertyDescriptor pd : properties) {
                if (pd.getValue() == null) continue;
                propMessages.add(new PropertyMessage(this.webKit, pd));
            }
            return propMessages;
        }
        return super.getSubMessages();
    }
}

