/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.persistence.PersistenceLocationProviderImpl;
import org.netbeans.modules.gradle.persistence.PersistenceScopeProviderImpl;
import org.netbeans.modules.gradle.persistence.PersistenceScopesProviderImpl;
import org.netbeans.modules.gradle.spi.WatchedResourceProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class GradlePersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
WatchedResourceProvider {
    public static final String PROP_PERSISTENCE = "GradlePersistence";
    private PersistenceLocationProviderImpl locProvider = null;
    private PersistenceScopesProviderImpl scopesProvider = null;
    private PersistenceScopeProviderImpl scopeProvider = null;
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private final ResourceListener res = new ResourceListener();
    final Project project;

    public GradlePersistenceProvider(Project proj, Lookup lkp) {
        this.project = proj;
        NbGradleProject watcher = (NbGradleProject)lkp.lookup(NbGradleProject.class);
        this.locProvider = new PersistenceLocationProviderImpl(proj);
        this.scopeProvider = new PersistenceScopeProviderImpl(this.locProvider, proj);
        this.scopesProvider = new PersistenceScopesProviderImpl(this.scopeProvider);
        this.propChangeSupport.addPropertyChangeListener(this.locProvider);
        this.propChangeSupport.addPropertyChangeListener(this.scopesProvider);
        watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.res, (Object)watcher));
    }

    public FileObject getLocation() {
        return this.locProvider.getLocation();
    }

    public FileObject createLocation() throws IOException {
        return this.locProvider.createLocation();
    }

    public PersistenceScope findPersistenceScope(FileObject fileObject) {
        return this.scopeProvider.findPersistenceScope(fileObject);
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesProvider.getPersistenceScopes();
    }

    public Set<File> getWatchedResources() {
        GradleJavaProject gjp = GradleJavaProject.get((Project)this.project);
        if (gjp != null && gjp.getMainSourceSet() != null) {
            Collection roots = gjp.getMainSourceSet().getAllDirs();
            LinkedHashSet<File> ret = new LinkedHashSet<File>();
            for (File root : roots) {
                ret.add(new File(root, "META-INF/persistence.xml"));
            }
            return ret;
        }
        return Collections.emptySet();
    }

    private class ResourceListener
    implements PropertyChangeListener {
        private ResourceListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            URI newval;
            if ("resources".equals(event.getPropertyName()) && (newval = (URI)event.getNewValue()).getPath().endsWith("META-INF/persistence.xml")) {
                GradlePersistenceProvider.this.propChangeSupport.firePropertyChange(GradlePersistenceProvider.PROP_PERSISTENCE, null, null);
            }
        }
    }
}

